/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.function.LongFunction;
import org.apache.ratis.client.DataStreamClientRpc;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.impl.DataStreamPacketByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamRequestByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamRequestFilePositionCount;
import org.apache.ratis.io.FilePositionCount;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.DataStreamReply;
import org.apache.ratis.protocol.DataStreamRequest;
import org.apache.ratis.protocol.DataStreamRequestHeader;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SlidingWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedStreamAsync {
    public static final Logger LOG = LoggerFactory.getLogger(OrderedStreamAsync.class);
    private final DataStreamClientRpc dataStreamClientRpc;
    private final SlidingWindow.Client<DataStreamWindowRequest, DataStreamReply> slidingWindow;
    private final Semaphore requestSemaphore;

    OrderedStreamAsync(ClientId clientId, DataStreamClientRpc dataStreamClientRpc, RaftProperties properties) {
        this.dataStreamClientRpc = dataStreamClientRpc;
        this.slidingWindow = new SlidingWindow.Client((Object)clientId);
        this.requestSemaphore = new Semaphore(RaftClientConfigKeys.DataStream.outstandingRequestsMax(properties));
    }

    CompletableFuture<DataStreamReply> sendRequest(DataStreamRequestHeader header, Object data) {
        try {
            this.requestSemaphore.acquire();
        }
        catch (InterruptedException e2) {
            return JavaUtils.completeExceptionally((Throwable)IOUtils.toInterruptedIOException((String)("Interrupted when sending " + JavaUtils.getClassSimpleName(data.getClass()) + ", header= " + header), (InterruptedException)e2));
        }
        LongFunction<DataStreamWindowRequest> constructor = seqNum -> new DataStreamWindowRequest(header, data, seqNum);
        return ((DataStreamWindowRequest)this.slidingWindow.submitNewRequest(constructor, this::sendRequestToNetwork)).getReplyFuture().whenComplete((r, e) -> this.requestSemaphore.release());
    }

    private void sendRequestToNetwork(DataStreamWindowRequest request) {
        CompletableFuture<DataStreamReply> f = request.getReplyFuture();
        if (f.isDone()) {
            return;
        }
        if (this.slidingWindow.isFirst(request.getSeqNum())) {
            request.setFirstRequest();
        }
        CompletableFuture<DataStreamReply> requestFuture = this.dataStreamClientRpc.streamAsync(request.getDataStreamRequest());
        long seqNum = request.getSeqNum();
        ((CompletableFuture)requestFuture.thenApply(reply -> {
            this.slidingWindow.receiveReply(seqNum, reply, this::sendRequestToNetwork);
            return reply;
        })).thenAccept(reply -> {
            if (f.isDone()) {
                return;
            }
            f.complete((DataStreamReply)reply);
        });
    }

    static class DataStreamWindowRequest
    implements SlidingWindow.ClientSideRequest<DataStreamReply> {
        private final DataStreamRequestHeader header;
        private final Object data;
        private final long seqNum;
        private final CompletableFuture<DataStreamReply> replyFuture = new CompletableFuture();

        DataStreamWindowRequest(DataStreamRequestHeader header, Object data, long seqNum) {
            this.header = header;
            this.data = data;
            this.seqNum = seqNum;
        }

        DataStreamRequest getDataStreamRequest() {
            if (this.header.getDataLength() == 0L) {
                return new DataStreamRequestByteBuffer(this.header, DataStreamPacketByteBuffer.EMPTY_BYTE_BUFFER);
            }
            if (this.data instanceof ByteBuffer) {
                return new DataStreamRequestByteBuffer(this.header, (ByteBuffer)this.data);
            }
            if (this.data instanceof FilePositionCount) {
                return new DataStreamRequestFilePositionCount(this.header, (FilePositionCount)this.data);
            }
            throw new IllegalStateException("Unexpected " + this.data.getClass());
        }

        public void setFirstRequest() {
        }

        public long getSeqNum() {
            return this.seqNum;
        }

        public void setReply(DataStreamReply dataStreamReply) {
            this.replyFuture.complete(dataStreamReply);
        }

        public boolean hasReply() {
            return this.replyFuture.isDone();
        }

        public void fail(Throwable e) {
            this.replyFuture.completeExceptionally(e);
        }

        public CompletableFuture<DataStreamReply> getReplyFuture() {
            return this.replyFuture;
        }
    }
}

