/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.namesrv;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.namesrv.NamesrvConfig;
import org.apache.rocketmq.namesrv.NamesrvController;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.srvutil.ShutdownHookThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamesrvStartup {
    public static Properties properties = null;
    public static CommandLine commandLine = null;

    public static void main(String[] args) {
        NamesrvStartup.main0(args);
    }

    public static NamesrvController main0(String[] args) {
        System.setProperty("rocketmq.remoting.version", Integer.toString(MQVersion.CURRENT_VERSION));
        try {
            String file;
            Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
            commandLine = ServerUtil.parseCmdLine((String)"mqnamesrv", (String[])args, (Options)NamesrvStartup.buildCommandlineOptions(options), (CommandLineParser)new PosixParser());
            if (null == commandLine) {
                System.exit(-1);
                return null;
            }
            NamesrvConfig namesrvConfig = new NamesrvConfig();
            NettyServerConfig nettyServerConfig = new NettyServerConfig();
            nettyServerConfig.setListenPort(9876);
            if (commandLine.hasOption('c') && (file = commandLine.getOptionValue('c')) != null) {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                properties = new Properties();
                properties.load(in);
                MixAll.properties2Object((Properties)properties, (Object)namesrvConfig);
                MixAll.properties2Object((Properties)properties, (Object)nettyServerConfig);
                namesrvConfig.setConfigStorePath(file);
                System.out.printf("load config properties file OK, " + file + "%n", new Object[0]);
                ((InputStream)in).close();
            }
            if (commandLine.hasOption('p')) {
                MixAll.printObjectProperties(null, (Object)namesrvConfig);
                MixAll.printObjectProperties(null, (Object)nettyServerConfig);
                System.exit(0);
            }
            MixAll.properties2Object((Properties)ServerUtil.commandLine2Properties((CommandLine)commandLine), (Object)namesrvConfig);
            if (null == namesrvConfig.getRocketmqHome()) {
                System.out.printf("Please set the %s variable in your environment to match the location of the RocketMQ installation%n", "ROCKETMQ_HOME");
                System.exit(-2);
            }
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            lc.reset();
            configurator.doConfigure(namesrvConfig.getRocketmqHome() + "/conf/logback_namesrv.xml");
            Logger log = LoggerFactory.getLogger((String)"RocketmqNamesrv");
            MixAll.printObjectProperties((Logger)log, (Object)namesrvConfig);
            MixAll.printObjectProperties((Logger)log, (Object)nettyServerConfig);
            final NamesrvController controller = new NamesrvController(namesrvConfig, nettyServerConfig);
            controller.getConfiguration().registerConfig(properties);
            boolean initResult = controller.initialize();
            if (!initResult) {
                controller.shutdown();
                System.exit(-3);
            }
            Runtime.getRuntime().addShutdownHook((Thread)new ShutdownHookThread(log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    controller.shutdown();
                    return null;
                }
            }));
            controller.start();
            String tip = "The Name Server boot success. serializeType=" + RemotingCommand.getSerializeTypeConfigInThisServer();
            log.info(tip);
            System.out.printf(tip + "%n", new Object[0]);
            return controller;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "configFile", true, "Name server config properties file");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("p", "printConfigItem", false, "Print all config item");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }
}

