/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.namesrv;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.namesrv.NamesrvConfig;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.namesrv.NamesrvController;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.srvutil.ShutdownHookThread;
import org.slf4j.LoggerFactory;

public class NamesrvStartup {
    private static InternalLogger log;
    private static Properties properties;
    private static CommandLine commandLine;

    public static void main(String[] args) {
        NamesrvStartup.main0(args);
    }

    public static NamesrvController main0(String[] args) {
        try {
            NamesrvController controller = NamesrvStartup.createNamesrvController(args);
            NamesrvStartup.start(controller);
            String tip = "The Name Server boot success. serializeType=" + RemotingCommand.getSerializeTypeConfigInThisServer();
            log.info(tip);
            System.out.printf("%s%n", tip);
            return controller;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static NamesrvController createNamesrvController(String[] args) throws IOException, JoranException {
        String file;
        System.setProperty("rocketmq.remoting.version", Integer.toString(MQVersion.CURRENT_VERSION));
        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
        commandLine = ServerUtil.parseCmdLine((String)"mqnamesrv", (String[])args, (Options)NamesrvStartup.buildCommandlineOptions(options), (CommandLineParser)new PosixParser());
        if (null == commandLine) {
            System.exit(-1);
            return null;
        }
        NamesrvConfig namesrvConfig = new NamesrvConfig();
        NettyServerConfig nettyServerConfig = new NettyServerConfig();
        nettyServerConfig.setListenPort(9876);
        if (commandLine.hasOption('c') && (file = commandLine.getOptionValue('c')) != null) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            properties = new Properties();
            properties.load(in);
            MixAll.properties2Object((Properties)properties, (Object)namesrvConfig);
            MixAll.properties2Object((Properties)properties, (Object)nettyServerConfig);
            namesrvConfig.setConfigStorePath(file);
            System.out.printf("load config properties file OK, %s%n", file);
            ((InputStream)in).close();
        }
        if (commandLine.hasOption('p')) {
            InternalLogger console = InternalLoggerFactory.getLogger((String)"RocketmqNamesrvConsole");
            MixAll.printObjectProperties((InternalLogger)console, (Object)namesrvConfig);
            MixAll.printObjectProperties((InternalLogger)console, (Object)nettyServerConfig);
            System.exit(0);
        }
        MixAll.properties2Object((Properties)ServerUtil.commandLine2Properties((CommandLine)commandLine), (Object)namesrvConfig);
        if (null == namesrvConfig.getRocketmqHome()) {
            System.out.printf("Please set the %s variable in your environment to match the location of the RocketMQ installation%n", "ROCKETMQ_HOME");
            System.exit(-2);
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        configurator.doConfigure(namesrvConfig.getRocketmqHome() + "/conf/logback_namesrv.xml");
        log = InternalLoggerFactory.getLogger((String)"RocketmqNamesrv");
        MixAll.printObjectProperties((InternalLogger)log, (Object)namesrvConfig);
        MixAll.printObjectProperties((InternalLogger)log, (Object)nettyServerConfig);
        NamesrvController controller = new NamesrvController(namesrvConfig, nettyServerConfig);
        controller.getConfiguration().registerConfig(properties);
        return controller;
    }

    public static NamesrvController start(final NamesrvController controller) throws Exception {
        if (null == controller) {
            throw new IllegalArgumentException("NamesrvController is null");
        }
        boolean initResult = controller.initialize();
        if (!initResult) {
            controller.shutdown();
            System.exit(-3);
        }
        Runtime.getRuntime().addShutdownHook((Thread)new ShutdownHookThread(log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                controller.shutdown();
                return null;
            }
        }));
        controller.start();
        return controller;
    }

    public static void shutdown(NamesrvController controller) {
        controller.shutdown();
    }

    public static Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "configFile", true, "Name server config properties file");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("p", "printConfigItem", false, "Print all config items");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    public static Properties getProperties() {
        return properties;
    }

    static {
        properties = null;
        commandLine = null;
    }
}

