/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.dledger;

import io.openmessaging.storage.dledger.AppendFuture;
import io.openmessaging.storage.dledger.DLedgerConfig;
import io.openmessaging.storage.dledger.DLedgerServer;
import io.openmessaging.storage.dledger.protocol.AppendEntryRequest;
import io.openmessaging.storage.dledger.protocol.AppendEntryResponse;
import io.openmessaging.storage.dledger.protocol.DLedgerResponseCode;
import io.openmessaging.storage.dledger.store.file.DLedgerMmapFileStore;
import io.openmessaging.storage.dledger.store.file.MmapFile;
import io.openmessaging.storage.dledger.store.file.MmapFileList;
import io.openmessaging.storage.dledger.store.file.SelectMmapBufferResult;
import io.openmessaging.storage.dledger.utils.DLedgerUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExtBatch;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.store.AppendMessageResult;
import org.apache.rocketmq.store.AppendMessageStatus;
import org.apache.rocketmq.store.CommitLog;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.MappedFile;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.schedule.ScheduleMessageService;

public class DLedgerCommitLog
extends CommitLog {
    private final DLedgerServer dLedgerServer;
    private final DLedgerConfig dLedgerConfig = new DLedgerConfig();
    private final DLedgerMmapFileStore dLedgerFileStore;
    private final MmapFileList dLedgerFileList;
    private final int id;
    private final MessageSerializer messageSerializer;
    private volatile long beginTimeInDledgerLock = 0L;
    private long dividedCommitlogOffset = -1L;
    private boolean isInrecoveringOldCommitlog = false;

    public DLedgerCommitLog(DefaultMessageStore defaultMessageStore) {
        super(defaultMessageStore);
        this.dLedgerConfig.setEnableDiskForceClean(defaultMessageStore.getMessageStoreConfig().isCleanFileForciblyEnable());
        this.dLedgerConfig.setStoreType("FILE");
        this.dLedgerConfig.setSelfId(defaultMessageStore.getMessageStoreConfig().getdLegerSelfId());
        this.dLedgerConfig.setGroup(defaultMessageStore.getMessageStoreConfig().getdLegerGroup());
        this.dLedgerConfig.setPeers(defaultMessageStore.getMessageStoreConfig().getdLegerPeers());
        this.dLedgerConfig.setStoreBaseDir(defaultMessageStore.getMessageStoreConfig().getStorePathRootDir());
        this.dLedgerConfig.setMappedFileSizeForEntryData(defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog());
        this.dLedgerConfig.setDeleteWhen(defaultMessageStore.getMessageStoreConfig().getDeleteWhen());
        this.dLedgerConfig.setFileReservedHours(defaultMessageStore.getMessageStoreConfig().getFileReservedTime() + 1);
        this.id = Integer.valueOf(this.dLedgerConfig.getSelfId().substring(1)) + 1;
        this.dLedgerServer = new DLedgerServer(this.dLedgerConfig);
        this.dLedgerFileStore = (DLedgerMmapFileStore)this.dLedgerServer.getdLedgerStore();
        DLedgerMmapFileStore.AppendHook appendHook = (entry, buffer, bodyOffset) -> {
            assert (bodyOffset == 48);
            buffer.position(buffer.position() + bodyOffset + 28);
            buffer.putLong(entry.getPos() + (long)bodyOffset);
        };
        this.dLedgerFileStore.addAppendHook(appendHook);
        this.dLedgerFileList = this.dLedgerFileStore.getDataFileList();
        this.messageSerializer = new MessageSerializer(defaultMessageStore.getMessageStoreConfig().getMaxMessageSize());
    }

    @Override
    public boolean load() {
        return super.load();
    }

    private void refreshConfig() {
        this.dLedgerConfig.setEnableDiskForceClean(this.defaultMessageStore.getMessageStoreConfig().isCleanFileForciblyEnable());
        this.dLedgerConfig.setDeleteWhen(this.defaultMessageStore.getMessageStoreConfig().getDeleteWhen());
        this.dLedgerConfig.setFileReservedHours(this.defaultMessageStore.getMessageStoreConfig().getFileReservedTime() + 1);
    }

    private void disableDeleteDledger() {
        this.dLedgerConfig.setEnableDiskForceClean(false);
        this.dLedgerConfig.setFileReservedHours(87600);
    }

    @Override
    public void start() {
        this.dLedgerServer.startup();
    }

    @Override
    public void shutdown() {
        this.dLedgerServer.shutdown();
    }

    @Override
    public long flush() {
        this.dLedgerFileStore.flush();
        return this.dLedgerFileList.getFlushedWhere();
    }

    @Override
    public long getMaxOffset() {
        if (this.dLedgerFileStore.getCommittedPos() > 0L) {
            return this.dLedgerFileStore.getCommittedPos();
        }
        if (this.dLedgerFileList.getMinOffset() > 0L) {
            return this.dLedgerFileList.getMinOffset();
        }
        return 0L;
    }

    @Override
    public long getMinOffset() {
        if (!this.mappedFileQueue.getMappedFiles().isEmpty()) {
            return this.mappedFileQueue.getMinOffset();
        }
        return this.dLedgerFileList.getMinOffset();
    }

    @Override
    public long getConfirmOffset() {
        return this.getMaxOffset();
    }

    @Override
    public void setConfirmOffset(long phyOffset) {
        log.warn("Should not set confirm offset {} for dleger commitlog", (Object)phyOffset);
    }

    @Override
    public long remainHowManyDataToCommit() {
        return this.dLedgerFileList.remainHowManyDataToCommit();
    }

    @Override
    public long remainHowManyDataToFlush() {
        return this.dLedgerFileList.remainHowManyDataToFlush();
    }

    @Override
    public int deleteExpiredFile(long expiredTime, int deleteFilesInterval, long intervalForcibly, boolean cleanImmediately) {
        if (this.mappedFileQueue.getMappedFiles().isEmpty()) {
            this.refreshConfig();
            return Integer.MAX_VALUE;
        }
        this.disableDeleteDledger();
        int count = super.deleteExpiredFile(expiredTime, deleteFilesInterval, intervalForcibly, cleanImmediately);
        if (count > 0 || this.mappedFileQueue.getMappedFiles().size() != 1) {
            return count;
        }
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
        log.info("Try to delete the last old commitlog file {}", (Object)mappedFile.getFileName());
        long liveMaxTimestamp = mappedFile.getLastModifiedTimestamp() + expiredTime;
        if (System.currentTimeMillis() >= liveMaxTimestamp || cleanImmediately) {
            while (!mappedFile.destroy(10000L)) {
                DLedgerUtils.sleep((long)1000L);
            }
            this.mappedFileQueue.getMappedFiles().remove(mappedFile);
        }
        return 1;
    }

    public SelectMappedBufferResult convertSbr(SelectMmapBufferResult sbr) {
        if (sbr == null) {
            return null;
        }
        return new DLedgerSelectMappedBufferResult(sbr);
    }

    public SelectMmapBufferResult truncate(SelectMmapBufferResult sbr) {
        long committedPos = this.dLedgerFileStore.getCommittedPos();
        if (sbr == null || sbr.getStartOffset() == committedPos) {
            return null;
        }
        if (sbr.getStartOffset() + (long)sbr.getSize() <= committedPos) {
            return sbr;
        }
        sbr.setSize((int)(committedPos - sbr.getStartOffset()));
        return sbr;
    }

    @Override
    public SelectMappedBufferResult getData(long offset) {
        if (offset < this.dividedCommitlogOffset) {
            return super.getData(offset);
        }
        return this.getData(offset, offset == 0L);
    }

    @Override
    public SelectMappedBufferResult getData(long offset, boolean returnFirstOnNotFound) {
        if (offset < this.dividedCommitlogOffset) {
            return super.getData(offset, returnFirstOnNotFound);
        }
        if (offset >= this.dLedgerFileStore.getCommittedPos()) {
            return null;
        }
        int mappedFileSize = this.dLedgerServer.getdLedgerConfig().getMappedFileSizeForEntryData();
        MmapFile mappedFile = this.dLedgerFileList.findMappedFileByOffset(offset, returnFirstOnNotFound);
        if (mappedFile != null) {
            int pos = (int)(offset % (long)mappedFileSize);
            SelectMmapBufferResult sbr = mappedFile.selectMappedBuffer(pos);
            return this.convertSbr(this.truncate(sbr));
        }
        return null;
    }

    private void recover(long maxPhyOffsetOfConsumeQueue) {
        this.dLedgerFileStore.load();
        if (this.dLedgerFileList.getMappedFiles().size() > 0) {
            long maxPhyOffset;
            this.dLedgerFileStore.recover();
            this.dividedCommitlogOffset = this.dLedgerFileList.getFirstMappedFile().getFileFromOffset();
            MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
            if (mappedFile != null) {
                this.disableDeleteDledger();
            }
            if (maxPhyOffsetOfConsumeQueue >= (maxPhyOffset = this.dLedgerFileList.getMaxWrotePosition())) {
                log.warn("[TruncateCQ]maxPhyOffsetOfConsumeQueue({}) >= processOffset({}), truncate dirty logic files", (Object)maxPhyOffsetOfConsumeQueue, (Object)maxPhyOffset);
                this.defaultMessageStore.truncateDirtyLogicFiles(maxPhyOffset);
            }
            return;
        }
        this.isInrecoveringOldCommitlog = true;
        super.recoverNormally(maxPhyOffsetOfConsumeQueue);
        this.isInrecoveringOldCommitlog = false;
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
        if (mappedFile == null) {
            return;
        }
        ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
        byteBuffer.position(mappedFile.getWrotePosition());
        boolean needWriteMagicCode = true;
        byteBuffer.getInt();
        int magicCode = byteBuffer.getInt();
        if (magicCode == -875286124) {
            needWriteMagicCode = false;
        } else {
            log.info("Recover old commitlog found a illegal magic code={}", (Object)magicCode);
        }
        this.dLedgerConfig.setEnableDiskForceClean(false);
        this.dividedCommitlogOffset = mappedFile.getFileFromOffset() + (long)mappedFile.getFileSize();
        log.info("Recover old commitlog needWriteMagicCode={} pos={} file={} dividedCommitlogOffset={}", new Object[]{needWriteMagicCode, mappedFile.getFileFromOffset() + (long)mappedFile.getWrotePosition(), mappedFile.getFileName(), this.dividedCommitlogOffset});
        if (needWriteMagicCode) {
            byteBuffer.position(mappedFile.getWrotePosition());
            byteBuffer.putInt(mappedFile.getFileSize() - mappedFile.getWrotePosition());
            byteBuffer.putInt(-875286124);
            mappedFile.flush(0);
        }
        mappedFile.setWrotePosition(mappedFile.getFileSize());
        mappedFile.setCommittedPosition(mappedFile.getFileSize());
        mappedFile.setFlushedPosition(mappedFile.getFileSize());
        this.dLedgerFileList.getLastMappedFile(this.dividedCommitlogOffset);
        log.info("Will set the initial commitlog offset={} for dledger", (Object)this.dividedCommitlogOffset);
    }

    @Override
    public void recoverNormally(long maxPhyOffsetOfConsumeQueue) {
        this.recover(maxPhyOffsetOfConsumeQueue);
    }

    @Override
    public void recoverAbnormally(long maxPhyOffsetOfConsumeQueue) {
        this.recover(maxPhyOffsetOfConsumeQueue);
    }

    @Override
    public DispatchRequest checkMessageAndReturnSize(ByteBuffer byteBuffer, boolean checkCRC) {
        return this.checkMessageAndReturnSize(byteBuffer, checkCRC, true);
    }

    @Override
    public DispatchRequest checkMessageAndReturnSize(ByteBuffer byteBuffer, boolean checkCRC, boolean readBody) {
        if (this.isInrecoveringOldCommitlog) {
            return super.checkMessageAndReturnSize(byteBuffer, checkCRC, readBody);
        }
        try {
            int bodyOffset = 48;
            int pos = byteBuffer.position();
            int magic = byteBuffer.getInt();
            int magicOld = byteBuffer.getInt();
            if (magicOld == -875286124 || magicOld == -626843481) {
                byteBuffer.position(pos);
                return super.checkMessageAndReturnSize(byteBuffer, checkCRC, readBody);
            }
            if (magic == -1) {
                return new DispatchRequest(0, true);
            }
            byteBuffer.position(pos + bodyOffset);
            DispatchRequest dispatchRequest = super.checkMessageAndReturnSize(byteBuffer, checkCRC, readBody);
            if (dispatchRequest.isSuccess()) {
                dispatchRequest.setBufferSize(dispatchRequest.getMsgSize() + bodyOffset);
            } else if (dispatchRequest.getMsgSize() > 0) {
                dispatchRequest.setBufferSize(dispatchRequest.getMsgSize() + bodyOffset);
            }
            return dispatchRequest;
        }
        catch (Throwable throwable) {
            return new DispatchRequest(-1, false);
        }
    }

    @Override
    public boolean resetOffset(long offset) {
        return false;
    }

    @Override
    public long getBeginTimeInLock() {
        return this.beginTimeInDledgerLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public PutMessageResult putMessage(MessageExtBrokerInner msg) {
        msg.setStoreTimestamp(System.currentTimeMillis());
        msg.setBodyCRC(UtilAll.crc32((byte[])msg.getBody()));
        storeStatsService = this.defaultMessageStore.getStoreStatsService();
        topic = msg.getTopic();
        queueId = msg.getQueueId();
        tranType = MessageSysFlag.getTransactionValue((int)msg.getSysFlag());
        if ((tranType == 0 || tranType == 8) && msg.getDelayTimeLevel() > 0) {
            if (msg.getDelayTimeLevel() > this.defaultMessageStore.getScheduleMessageService().getMaxDelayLevel()) {
                msg.setDelayTimeLevel(this.defaultMessageStore.getScheduleMessageService().getMaxDelayLevel());
            }
            topic = "SCHEDULE_TOPIC_XXXX";
            queueId = ScheduleMessageService.delayLevel2QueueId(msg.getDelayTimeLevel());
            MessageAccessor.putProperty((Message)msg, (String)"REAL_TOPIC", (String)msg.getTopic());
            MessageAccessor.putProperty((Message)msg, (String)"REAL_QID", (String)String.valueOf(msg.getQueueId()));
            msg.setPropertiesString(MessageDecoder.messageProperties2String((Map)msg.getProperties()));
            msg.setTopic(topic);
            msg.setQueueId(queueId);
        }
        this.putMessageLock.lock();
        try {
            this.beginTimeInDledgerLock = this.defaultMessageStore.getSystemClock().now();
            encodeResult = this.messageSerializer.serialize(msg);
            queueOffset = (Long)this.topicQueueTable.get(EncodeResult.access$000(encodeResult));
            if (EncodeResult.access$100(encodeResult) != AppendMessageStatus.PUT_OK) {
                var13_8 = new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, new AppendMessageResult(EncodeResult.access$100(encodeResult)));
                return var13_8;
            }
            request = new AppendEntryRequest();
            request.setGroup(this.dLedgerConfig.getGroup());
            request.setRemoteId(this.dLedgerServer.getMemberState().getSelfId());
            request.setBody(EncodeResult.access$200(encodeResult));
            dledgerFuture = (AppendFuture)this.dLedgerServer.handleAppend(request);
            if (dledgerFuture.getPos() == -1L) {
                var14_12 = new PutMessageResult(PutMessageStatus.OS_PAGECACHE_BUSY, new AppendMessageResult(AppendMessageStatus.UNKNOWN_ERROR));
                return var14_12;
            }
            wroteOffset = dledgerFuture.getPos() + 48L;
            msgIdLength = (msg.getSysFlag() & 32) == 0 ? 16 : 28;
            buffer = ByteBuffer.allocate(msgIdLength);
            msgId = MessageDecoder.createMessageId((ByteBuffer)buffer, (ByteBuffer)msg.getStoreHostBytes(), (long)wroteOffset);
            elapsedTimeInLock = this.defaultMessageStore.getSystemClock().now() - this.beginTimeInDledgerLock;
            appendResult = new AppendMessageResult(AppendMessageStatus.PUT_OK, wroteOffset, EncodeResult.access$200(encodeResult).length, msgId, System.currentTimeMillis(), queueOffset, elapsedTimeInLock);
            switch (tranType) {
                case 4: 
                case 12: {
                    ** break;
lbl42:
                    // 1 sources

                    break;
                }
                case 0: 
                case 8: {
                    this.topicQueueTable.put(EncodeResult.access$000(encodeResult), queueOffset + 1L);
                    ** break;
lbl47:
                    // 1 sources

                    break;
                }
                ** default:
lbl49:
                // 1 sources

                break;
            }
        }
        catch (Exception e) {
            DLedgerCommitLog.log.error("Put message error", (Throwable)e);
            wroteOffset = new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, new AppendMessageResult(AppendMessageStatus.UNKNOWN_ERROR));
            return wroteOffset;
        }
        finally {
            this.beginTimeInDledgerLock = 0L;
            this.putMessageLock.unlock();
        }
        if (elapsedTimeInLock > 500L) {
            DLedgerCommitLog.log.warn("[NOTIFYME]putMessage in lock cost time(ms)={}, bodyLength={} AppendMessageResult={}", new Object[]{elapsedTimeInLock, msg.getBody().length, appendResult});
        }
        putMessageStatus = PutMessageStatus.UNKNOWN_ERROR;
        try {
            appendEntryResponse = (AppendEntryResponse)dledgerFuture.get(3L, TimeUnit.SECONDS);
            switch (1.$SwitchMap$io$openmessaging$storage$dledger$protocol$DLedgerResponseCode[DLedgerResponseCode.valueOf((int)appendEntryResponse.getCode()).ordinal()]) {
                case 1: {
                    putMessageStatus = PutMessageStatus.PUT_OK;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    putMessageStatus = PutMessageStatus.SERVICE_NOT_AVAILABLE;
                    break;
                }
                case 6: {
                    putMessageStatus = PutMessageStatus.OS_PAGECACHE_BUSY;
                    break;
                }
                case 7: {
                    putMessageStatus = PutMessageStatus.OS_PAGECACHE_BUSY;
                }
            }
        }
        catch (Throwable t) {
            DLedgerCommitLog.log.error("Failed to get dledger append result", t);
        }
        putMessageResult = new PutMessageResult(putMessageStatus, appendResult);
        if (putMessageStatus == PutMessageStatus.PUT_OK) {
            storeStatsService.getSinglePutMessageTopicTimesTotal(msg.getTopic()).incrementAndGet();
            storeStatsService.getSinglePutMessageTopicSizeTotal(topic).addAndGet(appendResult.getWroteBytes());
        }
        return putMessageResult;
    }

    @Override
    public PutMessageResult putMessages(MessageExtBatch messageExtBatch) {
        return new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null);
    }

    @Override
    public SelectMappedBufferResult getMessage(long offset, int size) {
        if (offset < this.dividedCommitlogOffset) {
            return super.getMessage(offset, size);
        }
        int mappedFileSize = this.dLedgerServer.getdLedgerConfig().getMappedFileSizeForEntryData();
        MmapFile mappedFile = this.dLedgerFileList.findMappedFileByOffset(offset, offset == 0L);
        if (mappedFile != null) {
            int pos = (int)(offset % (long)mappedFileSize);
            return this.convertSbr(mappedFile.selectMappedBuffer(pos, size));
        }
        return null;
    }

    @Override
    public long rollNextFile(long offset) {
        int mappedFileSize = this.defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog();
        return offset + (long)mappedFileSize - offset % (long)mappedFileSize;
    }

    @Override
    public HashMap<String, Long> getTopicQueueTable() {
        return this.topicQueueTable;
    }

    @Override
    public void setTopicQueueTable(HashMap<String, Long> topicQueueTable) {
        this.topicQueueTable = topicQueueTable;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.dLedgerFileList.destroy();
    }

    @Override
    public boolean appendData(long startOffset, byte[] data) {
        return false;
    }

    @Override
    public void checkSelf() {
        this.dLedgerFileList.checkSelf();
    }

    @Override
    public long lockTimeMills() {
        long diff = 0L;
        long begin = this.beginTimeInDledgerLock;
        if (begin > 0L) {
            diff = this.defaultMessageStore.now() - begin;
        }
        if (diff < 0L) {
            diff = 0L;
        }
        return diff;
    }

    public DLedgerServer getdLedgerServer() {
        return this.dLedgerServer;
    }

    public int getId() {
        return this.id;
    }

    public long getDividedCommitlogOffset() {
        return this.dividedCommitlogOffset;
    }

    public static class DLedgerSelectMappedBufferResult
    extends SelectMappedBufferResult {
        private SelectMmapBufferResult sbr;

        public DLedgerSelectMappedBufferResult(SelectMmapBufferResult sbr) {
            super(sbr.getStartOffset(), sbr.getByteBuffer(), sbr.getSize(), null);
            this.sbr = sbr;
        }

        @Override
        public synchronized void release() {
            super.release();
            if (this.sbr != null) {
                this.sbr.release();
            }
        }
    }

    class MessageSerializer {
        private static final int END_FILE_MIN_BLANK_LENGTH = 8;
        private final ByteBuffer msgIdMemory;
        private final ByteBuffer msgIdV6Memory;
        private final ByteBuffer msgStoreItemMemory;
        private final int maxMessageSize;
        private final StringBuilder keyBuilder = new StringBuilder();
        private final StringBuilder msgIdBuilder = new StringBuilder();

        MessageSerializer(int size) {
            this.msgIdMemory = ByteBuffer.allocate(16);
            this.msgIdV6Memory = ByteBuffer.allocate(28);
            this.msgStoreItemMemory = ByteBuffer.allocate(size + 8);
            this.maxMessageSize = size;
        }

        public ByteBuffer getMsgStoreItemMemory() {
            return this.msgStoreItemMemory;
        }

        public EncodeResult serialize(MessageExtBrokerInner msgInner) {
            int propertiesLength;
            long wroteOffset = 0L;
            int sysflag = msgInner.getSysFlag();
            int bornHostLength = (sysflag & 0x10) == 0 ? 8 : 20;
            int storeHostLength = (sysflag & 0x20) == 0 ? 8 : 20;
            ByteBuffer bornHostHolder = ByteBuffer.allocate(bornHostLength);
            ByteBuffer storeHostHolder = ByteBuffer.allocate(storeHostLength);
            this.keyBuilder.setLength(0);
            this.keyBuilder.append(msgInner.getTopic());
            this.keyBuilder.append('-');
            this.keyBuilder.append(msgInner.getQueueId());
            String key = this.keyBuilder.toString();
            Long queueOffset = (Long)DLedgerCommitLog.this.topicQueueTable.get(key);
            if (null == queueOffset) {
                queueOffset = 0L;
                DLedgerCommitLog.this.topicQueueTable.put(key, queueOffset);
            }
            int tranType = MessageSysFlag.getTransactionValue((int)msgInner.getSysFlag());
            switch (tranType) {
                case 4: 
                case 12: {
                    queueOffset = 0L;
                    break;
                }
            }
            byte[] propertiesData = msgInner.getPropertiesString() == null ? null : msgInner.getPropertiesString().getBytes(MessageDecoder.CHARSET_UTF8);
            int n = propertiesLength = propertiesData == null ? 0 : propertiesData.length;
            if (propertiesLength > Short.MAX_VALUE) {
                log.warn("putMessage message properties length too long. length={}", (Object)propertiesData.length);
                return new EncodeResult(AppendMessageStatus.PROPERTIES_SIZE_EXCEEDED, null, key);
            }
            byte[] topicData = msgInner.getTopic().getBytes(MessageDecoder.CHARSET_UTF8);
            int topicLength = topicData.length;
            int bodyLength = msgInner.getBody() == null ? 0 : msgInner.getBody().length;
            int msgLen = DLedgerCommitLog.calMsgLength(msgInner.getSysFlag(), bodyLength, topicLength, propertiesLength);
            if (msgLen > this.maxMessageSize) {
                log.warn("message size exceeded, msg total size: " + msgLen + ", msg body size: " + bodyLength + ", maxMessageSize: " + this.maxMessageSize);
                return new EncodeResult(AppendMessageStatus.MESSAGE_SIZE_EXCEEDED, null, key);
            }
            this.resetByteBuffer(this.msgStoreItemMemory, msgLen);
            this.msgStoreItemMemory.putInt(msgLen);
            this.msgStoreItemMemory.putInt(-626843481);
            this.msgStoreItemMemory.putInt(msgInner.getBodyCRC());
            this.msgStoreItemMemory.putInt(msgInner.getQueueId());
            this.msgStoreItemMemory.putInt(msgInner.getFlag());
            this.msgStoreItemMemory.putLong(queueOffset);
            this.msgStoreItemMemory.putLong(wroteOffset);
            this.msgStoreItemMemory.putInt(msgInner.getSysFlag());
            this.msgStoreItemMemory.putLong(msgInner.getBornTimestamp());
            this.resetByteBuffer(bornHostHolder, bornHostLength);
            this.msgStoreItemMemory.put(msgInner.getBornHostBytes(bornHostHolder));
            this.msgStoreItemMemory.putLong(msgInner.getStoreTimestamp());
            this.resetByteBuffer(storeHostHolder, storeHostLength);
            this.msgStoreItemMemory.put(msgInner.getStoreHostBytes(storeHostHolder));
            this.msgStoreItemMemory.putInt(msgInner.getReconsumeTimes());
            this.msgStoreItemMemory.putLong(msgInner.getPreparedTransactionOffset());
            this.msgStoreItemMemory.putInt(bodyLength);
            if (bodyLength > 0) {
                this.msgStoreItemMemory.put(msgInner.getBody());
            }
            this.msgStoreItemMemory.put((byte)topicLength);
            this.msgStoreItemMemory.put(topicData);
            this.msgStoreItemMemory.putShort((short)propertiesLength);
            if (propertiesLength > 0) {
                this.msgStoreItemMemory.put(propertiesData);
            }
            byte[] data = new byte[msgLen];
            this.msgStoreItemMemory.clear();
            this.msgStoreItemMemory.get(data);
            return new EncodeResult(AppendMessageStatus.PUT_OK, data, key);
        }

        private void resetByteBuffer(ByteBuffer byteBuffer, int limit) {
            byteBuffer.flip();
            byteBuffer.limit(limit);
        }
    }

    class EncodeResult {
        private String queueOffsetKey;
        private byte[] data;
        private AppendMessageStatus status;

        public EncodeResult(AppendMessageStatus status, byte[] data, String queueOffsetKey) {
            this.data = data;
            this.status = status;
            this.queueOffsetKey = queueOffsetKey;
        }

        static /* synthetic */ String access$000(EncodeResult x0) {
            return x0.queueOffsetKey;
        }

        static /* synthetic */ AppendMessageStatus access$100(EncodeResult x0) {
            return x0.status;
        }

        static /* synthetic */ byte[] access$200(EncodeResult x0) {
            return x0.data;
        }
    }
}

