/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Config {
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    public static final String CONSUMER_LIMIT_KEY_PREFIX = "cse.flowcontrol.Consumer.qps.limit.";
    public static final String PROVIDER_LIMIT_KEY_PREFIX = "cse.flowcontrol.Provider.qps.limit.";
    public static final String PROVIDER_LIMIT_KEY_GLOBAL = "cse.flowcontrol.Provider.qps.global.limit";
    public static final String CONSUMER_ENABLED = "cse.flowcontrol.Consumer.qps.enabled";
    public static final String PROVIDER_ENABLED = "cse.flowcontrol.Provider.qps.enabled";
    public static final Config INSTANCE = new Config();
    private final DynamicBooleanProperty consumerEanbled = DynamicPropertyFactory.getInstance().getBooleanProperty("cse.flowcontrol.Consumer.qps.enabled", true);
    private final DynamicBooleanProperty providerEanbled = DynamicPropertyFactory.getInstance().getBooleanProperty("cse.flowcontrol.Provider.qps.enabled", true);

    private Config() {
        this.consumerEanbled.addCallback(() -> {
            boolean newValue = this.consumerEanbled.get();
            LOGGER.info("{} changed from {} to {}", new Object[]{CONSUMER_ENABLED, this.consumerEanbled, newValue});
        });
        this.providerEanbled.addCallback(() -> {
            boolean newValue = this.providerEanbled.get();
            LOGGER.info("{} changed from {} to {}", new Object[]{PROVIDER_ENABLED, this.providerEanbled, newValue});
        });
    }

    public boolean isConsumerEnabled() {
        return this.consumerEanbled.get();
    }

    public boolean isProviderEnabled() {
        return this.providerEanbled.get();
    }
}

