/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.ShowDatabaseDiscoveryTypesStatement;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class DatabaseDiscoveryTypeQueryResultSet
implements DistSQLResultSet {
    private Iterator<Map.Entry<String, ShardingSphereAlgorithmConfiguration>> data = Collections.emptyIterator();

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        Collection ruleConfig = database.getRuleMetaData().findRuleConfigurations(DatabaseDiscoveryRuleConfiguration.class);
        this.data = ruleConfig.stream().map(DatabaseDiscoveryRuleConfiguration::getDiscoveryTypes).flatMap(each -> each.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).entrySet().iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "type", "props");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        Map.Entry<String, ShardingSphereAlgorithmConfiguration> entry = this.data.next();
        return Arrays.asList(entry.getKey(), entry.getValue().getType(), entry.getValue().getProps());
    }

    public String getType() {
        return ShowDatabaseDiscoveryTypesStatement.class.getName();
    }
}

