/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.parser.core.common;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.CommonDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.CommonDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.hint.ClearHintStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.set.SetInstanceStatusStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.set.SetVariableStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.show.ShowAllVariablesStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.show.ShowInstanceStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.show.ShowVariableStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.AlterResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.AddResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.DropResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowResourcesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowSingleTableRulesStatement;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.SchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class CommonDistSQLStatementVisitor
extends CommonDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitAddResource(CommonDistSQLStatementParser.AddResourceContext ctx) {
        return new AddResourceStatement((Collection)ctx.dataSource().stream().map(each -> (DataSourceSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterResource(CommonDistSQLStatementParser.AlterResourceContext ctx) {
        return new AlterResourceStatement((Collection)ctx.dataSource().stream().map(each -> (DataSourceSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDataSource(CommonDistSQLStatementParser.DataSourceContext ctx) {
        String url = null;
        String hostName = null;
        String port = null;
        String dbName = null;
        if (null != ctx.urlSource()) {
            url = new IdentifierValue(ctx.urlSource().url().getText()).getValue();
        }
        if (null != ctx.simpleSource()) {
            hostName = ctx.simpleSource().hostName().getText();
            port = ctx.simpleSource().port().getText();
            dbName = ctx.simpleSource().dbName().getText();
        }
        return new DataSourceSegment(this.getIdentifierValue((ParseTree)ctx.dataSourceName()), url, hostName, port, dbName, ctx.user().getText(), null == ctx.password() ? "" : this.getPassword(ctx.password()), null == ctx.poolProperties() ? new Properties() : this.getPoolProperties(ctx.poolProperties()));
    }

    private String getPassword(List<CommonDistSQLStatementParser.PasswordContext> passwordContexts) {
        return passwordContexts.stream().map(each -> new IdentifierValue(each.getText()).getValue()).collect(Collectors.joining(""));
    }

    @Override
    public ASTNode visitEnableInstance(CommonDistSQLStatementParser.EnableInstanceContext ctx) {
        return new SetInstanceStatusStatement(ctx.ENABLE().getText().toUpperCase(), new IdentifierValue(ctx.ip().getText()).getValue(), ctx.port().getText());
    }

    @Override
    public ASTNode visitShowInstance(CommonDistSQLStatementParser.ShowInstanceContext ctx) {
        return new ShowInstanceStatement();
    }

    @Override
    public ASTNode visitDisableInstance(CommonDistSQLStatementParser.DisableInstanceContext ctx) {
        return new SetInstanceStatusStatement(ctx.DISABLE().getText().toUpperCase(), new IdentifierValue(ctx.ip().getText()).getValue(), ctx.port().getText());
    }

    private Properties getPoolProperties(CommonDistSQLStatementParser.PoolPropertiesContext ctx) {
        Properties result = new Properties();
        for (CommonDistSQLStatementParser.PoolPropertyContext each : ctx.poolProperty()) {
            result.setProperty(new IdentifierValue(each.key.getText()).getValue(), new IdentifierValue(each.value.getText()).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitDropResource(CommonDistSQLStatementParser.DropResourceContext ctx) {
        boolean ignoreSingleTables = null != ctx.ignoreSingleTables();
        return new DropResourceStatement((Collection)ctx.IDENTIFIER().stream().map(ParseTree::getText).map(each -> new IdentifierValue(each).getValue()).collect(Collectors.toList()), ignoreSingleTables);
    }

    @Override
    public ASTNode visitShowResources(CommonDistSQLStatementParser.ShowResourcesContext ctx) {
        return new ShowResourcesStatement(null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitSchemaName(CommonDistSQLStatementParser.SchemaNameContext ctx) {
        return new SchemaSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitSetVariable(CommonDistSQLStatementParser.SetVariableContext ctx) {
        return new SetVariableStatement(this.getIdentifierValue((ParseTree)ctx.variableName()), this.getIdentifierValue((ParseTree)ctx.variableValue()));
    }

    @Override
    public ASTNode visitShowSinglesTableRules(CommonDistSQLStatementParser.ShowSinglesTableRulesContext ctx) {
        return new ShowSingleTableRulesStatement(null == ctx.tableRule() ? null : this.getIdentifierValue((ParseTree)ctx.tableRule().tableName()), null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitShowVariable(CommonDistSQLStatementParser.ShowVariableContext ctx) {
        return new ShowVariableStatement(this.getIdentifierValue((ParseTree)ctx.variableName()).toUpperCase());
    }

    @Override
    public ASTNode visitShowAllVariables(CommonDistSQLStatementParser.ShowAllVariablesContext ctx) {
        return new ShowAllVariablesStatement();
    }

    private String getIdentifierValue(ParseTree context) {
        if (null == context) {
            return null;
        }
        return new IdentifierValue(context.getText()).getValue();
    }

    @Override
    public ASTNode visitClearHint(CommonDistSQLStatementParser.ClearHintContext ctx) {
        return new ClearHintStatement();
    }
}

