/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.update;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.handler.converter.EncryptRuleStatementConverter;
import org.apache.shardingsphere.encrypt.distsql.parser.segment.EncryptRuleSegment;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.AlterEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleDefinitionViolationException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;

public final class AlterEncryptRuleStatementUpdater
implements RuleDefinitionAlterUpdater<AlterEncryptRuleStatement, EncryptRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, AlterEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) throws RuleDefinitionViolationException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkCurrentRuleConfiguration(schemaName, currentRuleConfig);
        this.checkToBeAlteredRules(schemaName, sqlStatement, currentRuleConfig);
        this.checkToBeAlteredEncryptors(sqlStatement);
    }

    private void checkCurrentRuleConfiguration(String schemaName, EncryptRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (null == currentRuleConfig) {
            throw new RequiredRuleMissedException("Encrypt", schemaName);
        }
    }

    private void checkToBeAlteredRules(String schemaName, AlterEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        Collection currentEncryptTableNames = currentRuleConfig.getTables().stream().map(EncryptTableRuleConfiguration::getName).collect(Collectors.toList());
        Collection notExistEncryptTableNames = this.getToBeAlteredEncryptTableNames(sqlStatement).stream().filter(each -> !currentEncryptTableNames.contains(each)).collect(Collectors.toList());
        if (!notExistEncryptTableNames.isEmpty()) {
            throw new RequiredRuleMissedException("Encrypt", schemaName, notExistEncryptTableNames);
        }
    }

    private Collection<String> getToBeAlteredEncryptTableNames(AlterEncryptRuleStatement sqlStatement) {
        return sqlStatement.getRules().stream().map(EncryptRuleSegment::getTableName).collect(Collectors.toList());
    }

    private void checkToBeAlteredEncryptors(AlterEncryptRuleStatement sqlStatement) throws InvalidAlgorithmConfigurationException {
        LinkedHashSet encryptors = new LinkedHashSet();
        for (EncryptRuleSegment each2 : sqlStatement.getRules()) {
            encryptors.addAll(each2.getColumns().stream().map(column -> column.getEncryptor().getName()).collect(Collectors.toSet()));
        }
        Collection invalidEncryptors = encryptors.stream().filter(each -> !TypedSPIRegistry.findRegisteredService(EncryptAlgorithm.class, (String)each, (Properties)new Properties()).isPresent()).collect(Collectors.toList());
        if (!invalidEncryptors.isEmpty()) {
            throw new InvalidAlgorithmConfigurationException("encryptor", invalidEncryptors);
        }
    }

    public RuleConfiguration buildToBeAlteredRuleConfiguration(AlterEncryptRuleStatement sqlStatement) {
        return EncryptRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public void updateCurrentRuleConfiguration(EncryptRuleConfiguration currentRuleConfig, EncryptRuleConfiguration toBeAlteredRuleConfig) {
        this.dropRuleConfiguration(currentRuleConfig, toBeAlteredRuleConfig);
        this.addRuleConfiguration(currentRuleConfig, toBeAlteredRuleConfig);
    }

    private void dropRuleConfiguration(EncryptRuleConfiguration currentRuleConfig, EncryptRuleConfiguration toBeAlteredRuleConfig) {
        for (EncryptTableRuleConfiguration each : toBeAlteredRuleConfig.getTables()) {
            Optional<EncryptTableRuleConfiguration> toBeRemovedTableRuleConfig = currentRuleConfig.getTables().stream().filter(tableRule -> tableRule.getName().equals(each.getName())).findAny();
            Preconditions.checkState((boolean)toBeRemovedTableRuleConfig.isPresent());
            currentRuleConfig.getTables().remove(toBeRemovedTableRuleConfig.get());
            toBeRemovedTableRuleConfig.get().getColumns().forEach(column -> {
                ShardingSphereAlgorithmConfiguration cfr_ignored_0 = (ShardingSphereAlgorithmConfiguration)currentRuleConfig.getEncryptors().remove(column.getEncryptorName());
            });
        }
    }

    private void addRuleConfiguration(EncryptRuleConfiguration currentRuleConfig, EncryptRuleConfiguration toBeAlteredRuleConfig) {
        currentRuleConfig.getTables().addAll(toBeAlteredRuleConfig.getTables());
        currentRuleConfig.getEncryptors().putAll(toBeAlteredRuleConfig.getEncryptors());
    }

    public Class<EncryptRuleConfiguration> getRuleConfigurationClass() {
        return EncryptRuleConfiguration.class;
    }

    public String getType() {
        return AlterEncryptRuleStatement.class.getCanonicalName();
    }

    static {
        ShardingSphereServiceLoader.register(EncryptAlgorithm.class);
    }
}

