/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.TableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.ColumnMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.SchemaMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.adapter.MetaDataLoaderConnectionAdapter;
import org.apache.shardingsphere.infra.metadata.schema.builder.spi.DialectTableMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.type.TableContainedRule;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;

public final class SchemaBuilder {
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Runtime.getRuntime().availableProcessors() * 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShardingSphere-SchemaBuilder-%d").build());

    public static ShardingSphereSchema build(SchemaBuilderMaterials materials) throws SQLException {
        ShardingSphereSchema result = new ShardingSphereSchema();
        SchemaBuilder.addRuleConfiguredTables(materials, result);
        SchemaBuilder.appendRemainTables(materials, result);
        return result;
    }

    private static void addRuleConfiguredTables(SchemaBuilderMaterials materials, ShardingSphereSchema schema) throws SQLException {
        for (ShardingSphereRule rule : materials.getRules()) {
            if (!(rule instanceof TableContainedRule)) continue;
            for (String table : ((TableContainedRule)rule).getTables()) {
                if (schema.containsTable(table)) continue;
                TableMetaDataBuilder.build(table, materials).ifPresent(optional -> schema.put(table, (TableMetaData)optional));
            }
        }
    }

    private static void appendRemainTables(SchemaBuilderMaterials materials, ShardingSphereSchema schema) throws SQLException {
        Optional<DialectTableMetaDataLoader> dialectLoader = SchemaBuilder.findDialectTableMetaDataLoader(materials);
        if (dialectLoader.isPresent()) {
            SchemaBuilder.appendDialectRemainTables(dialectLoader.get(), materials, schema);
            return;
        }
        SchemaBuilder.appendDefaultRemainTables(materials, schema);
    }

    private static Optional<DialectTableMetaDataLoader> findDialectTableMetaDataLoader(SchemaBuilderMaterials materials) {
        for (DialectTableMetaDataLoader each : ShardingSphereServiceLoader.getSingletonServiceInstances(DialectTableMetaDataLoader.class)) {
            if (!each.getDatabaseType().equals(materials.getDatabaseType().getName())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private static void appendDialectRemainTables(DialectTableMetaDataLoader dialectLoader, SchemaBuilderMaterials materials, ShardingSphereSchema schema) throws SQLException {
        LinkedList<Future<Map>> futures = new LinkedList<Future<Map>>();
        Collection<String> existedTables = SchemaBuilder.getExistedTables(materials.getRules(), schema);
        for (DataSource dataSource : materials.getDataSourceMap().values()) {
            futures.add(EXECUTOR_SERVICE.submit(() -> dialectLoader.load(dataSource, existedTables)));
        }
        for (Future future : futures) {
            try {
                schema.putAll((Map)future.get());
            }
            catch (InterruptedException | ExecutionException ex) {
                if (ex.getCause() instanceof SQLException) {
                    throw (SQLException)ex.getCause();
                }
                throw new ShardingSphereException(ex);
            }
        }
    }

    private static void appendDefaultRemainTables(SchemaBuilderMaterials materials, ShardingSphereSchema schema) throws SQLException {
        Collection<String> existedTableNames = SchemaBuilder.getExistedTables(materials.getRules(), schema);
        for (Map.Entry<String, DataSource> entry : materials.getDataSourceMap().entrySet()) {
            Collection<String> tableNames = SchemaMetaDataLoader.loadAllTableNames(entry.getValue(), materials.getDatabaseType());
            tableNames.removeAll(existedTableNames);
            for (String each : tableNames) {
                schema.put(each, SchemaBuilder.loadTableMetaData(each, entry.getValue(), materials.getDatabaseType()));
            }
        }
    }

    private static TableMetaData loadTableMetaData(String tableName, DataSource dataSource, DatabaseType databaseType) throws SQLException {
        TableMetaData result = new TableMetaData();
        try (MetaDataLoaderConnectionAdapter connection = new MetaDataLoaderConnectionAdapter(databaseType, dataSource.getConnection());){
            result.getColumns().putAll(SchemaBuilder.loadColumnMetaDataMap(tableName, databaseType, connection));
        }
        return result;
    }

    private static Map<String, ColumnMetaData> loadColumnMetaDataMap(String tableName, DatabaseType databaseType, Connection connection) throws SQLException {
        return ColumnMetaDataLoader.load(connection, tableName, databaseType).stream().collect(Collectors.toMap(ColumnMetaData::getName, each -> each, (a, b) -> b, LinkedHashMap::new));
    }

    private static Collection<String> getExistedTables(Collection<ShardingSphereRule> rules, ShardingSphereSchema schema) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ShardingSphereRule each : rules) {
            if (!(each instanceof DataNodeContainedRule)) continue;
            result.addAll(((DataNodeContainedRule)each).getAllActualTables());
        }
        result.addAll(schema.getAllTableNames());
        return result;
    }

    @Generated
    private SchemaBuilder() {
    }

    static {
        ShardingSphereServiceLoader.register(DialectTableMetaDataLoader.class);
    }
}

