/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.refresher.type;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.metadata.schema.refresher.SchemaRefresher;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterIndexStatementHandler;

public final class AlterIndexStatementSchemaRefresher
implements SchemaRefresher<AlterIndexStatement> {
    @Override
    public void refresh(ShardingSphereSchema schema, Collection<String> routeDataSourceNames, AlterIndexStatement sqlStatement, SchemaBuilderMaterials materials) {
        Optional renameIndex = AlterIndexStatementHandler.getRenameIndexSegment((AlterIndexStatement)sqlStatement);
        if (!sqlStatement.getIndex().isPresent() || !renameIndex.isPresent()) {
            return;
        }
        String indexName = ((IndexSegment)sqlStatement.getIndex().get()).getIdentifier().getValue();
        Optional<String> logicTableName = this.findLogicTableName(schema, indexName);
        if (logicTableName.isPresent()) {
            TableMetaData tableMetaData = schema.get(logicTableName.get());
            Preconditions.checkNotNull((Object)tableMetaData, (Object)String.format("Can not get the table '%s' metadata!", logicTableName.get()));
            tableMetaData.getIndexes().remove(indexName);
            String renameIndexName = ((IndexSegment)renameIndex.get()).getIdentifier().getValue();
            tableMetaData.getIndexes().put(renameIndexName, new IndexMetaData(renameIndexName));
        }
    }

    private Optional<String> findLogicTableName(ShardingSphereSchema schema, String indexName) {
        return schema.getAllTableNames().stream().filter(each -> schema.get((String)each).getIndexes().containsKey(indexName)).findFirst();
    }
}

