/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.refresher.type;

import java.util.Collection;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.metadata.schema.refresher.SchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.event.CreateTableEvent;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateViewStatement;

public final class CreateViewStatementSchemaRefresher
implements SchemaRefresher<CreateViewStatement> {
    @Override
    public void refresh(ShardingSphereSchema schema, Collection<String> routeDataSourceNames, CreateViewStatement sqlStatement, SchemaBuilderMaterials materials) {
        String viewName = sqlStatement.getView().getTableName().getIdentifier().getValue();
        TableMetaData tableMetaData = new TableMetaData();
        schema.put(viewName, tableMetaData);
        ShardingSphereEventBus.getInstance().post((Object)new CreateTableEvent(routeDataSourceNames.iterator().next(), viewName, tableMetaData));
    }
}

