/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rule.builder;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.level.DefaultKernelRuleConfigurationBuilder;
import org.apache.shardingsphere.infra.rule.builder.level.KernelRuleBuilder;
import org.apache.shardingsphere.infra.rule.builder.scope.GlobalRuleBuilder;
import org.apache.shardingsphere.infra.rule.builder.scope.SchemaRuleBuilder;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.ordered.OrderedSPIRegistry;

public final class ShardingSphereRulesBuilder {
    public static Collection<ShardingSphereRule> buildSchemaRules(String schemaName, Collection<RuleConfiguration> schemaRuleConfigurations, DatabaseType databaseType, Map<String, DataSource> dataSourceMap) {
        Map<RuleConfiguration, SchemaRuleBuilder> builders = OrderedSPIRegistry.getRegisteredServices(schemaRuleConfigurations, SchemaRuleBuilder.class);
        ShardingSphereRulesBuilder.appendDefaultKernelSchemaRuleConfigurationBuilder(builders);
        return builders.entrySet().stream().map(entry -> ((SchemaRuleBuilder)entry.getValue()).build(schemaName, dataSourceMap, databaseType, (RuleConfiguration)entry.getKey())).collect(Collectors.toList());
    }

    private static void appendDefaultKernelSchemaRuleConfigurationBuilder(Map<RuleConfiguration, SchemaRuleBuilder> builders) {
        Map<SchemaRuleBuilder, DefaultKernelRuleConfigurationBuilder> defaultBuilders = OrderedSPIRegistry.getRegisteredServices(ShardingSphereRulesBuilder.getMissedKernelSchemaRuleBuilders(builders.values()), DefaultKernelRuleConfigurationBuilder.class);
        for (Map.Entry<SchemaRuleBuilder, DefaultKernelRuleConfigurationBuilder> entry : defaultBuilders.entrySet()) {
            builders.put((RuleConfiguration)entry.getValue().build(), entry.getKey());
        }
    }

    private static Collection<SchemaRuleBuilder> getMissedKernelSchemaRuleBuilders(Collection<SchemaRuleBuilder> configuredBuilders) {
        Collection configuredBuilderClasses = configuredBuilders.stream().map(each -> each.getClass()).collect(Collectors.toSet());
        return OrderedSPIRegistry.getRegisteredServices(SchemaRuleBuilder.class).stream().filter(each -> each instanceof KernelRuleBuilder && !configuredBuilderClasses.contains(each.getClass())).collect(Collectors.toList());
    }

    public static Collection<ShardingSphereRule> buildGlobalRules(Collection<RuleConfiguration> globalRuleConfigurations, Map<String, ShardingSphereMetaData> mataDataMap) {
        Map<RuleConfiguration, GlobalRuleBuilder> builders = OrderedSPIRegistry.getRegisteredServices(globalRuleConfigurations, GlobalRuleBuilder.class);
        ShardingSphereRulesBuilder.appendDefaultKernelGlobalRuleConfigurationBuilder(builders);
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        for (Map.Entry<RuleConfiguration, GlobalRuleBuilder> entry : builders.entrySet()) {
            result.add(entry.getValue().build(entry.getKey(), mataDataMap));
        }
        return result;
    }

    private static void appendDefaultKernelGlobalRuleConfigurationBuilder(Map<RuleConfiguration, GlobalRuleBuilder> builders) {
        Map<GlobalRuleBuilder, DefaultKernelRuleConfigurationBuilder> defaultBuilders = OrderedSPIRegistry.getRegisteredServices(ShardingSphereRulesBuilder.getMissedKernelGlobalRuleBuilders(builders.values()), DefaultKernelRuleConfigurationBuilder.class);
        for (Map.Entry<GlobalRuleBuilder, DefaultKernelRuleConfigurationBuilder> entry : defaultBuilders.entrySet()) {
            builders.put((RuleConfiguration)entry.getValue().build(), entry.getKey());
        }
    }

    private static Collection<GlobalRuleBuilder> getMissedKernelGlobalRuleBuilders(Collection<GlobalRuleBuilder> configuredBuilders) {
        Collection configuredBuilderClasses = configuredBuilders.stream().map(each -> each.getClass()).collect(Collectors.toSet());
        return OrderedSPIRegistry.getRegisteredServices(GlobalRuleBuilder.class).stream().filter(each -> each instanceof KernelRuleBuilder && !configuredBuilderClasses.contains(each.getClass())).collect(Collectors.toList());
    }

    @Generated
    private ShardingSphereRulesBuilder() {
    }

    static {
        ShardingSphereServiceLoader.register(SchemaRuleBuilder.class);
        ShardingSphereServiceLoader.register(GlobalRuleBuilder.class);
        ShardingSphereServiceLoader.register(DefaultKernelRuleConfigurationBuilder.class);
    }
}

