/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.spi.ordered;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.ordered.OrderedSPI;
import org.apache.shardingsphere.infra.spi.ordered.cache.CachedOrderedServices;
import org.apache.shardingsphere.infra.spi.ordered.cache.OrderedServicesCache;

public final class OrderedSPIRegistry {
    public static <T extends OrderedSPI<?>> Map<Class<?>, T> getRegisteredServicesByClass(Collection<Class<?>> types, Class<T> orderedSPIClass) {
        Collection<OrderedSPI> registeredServices = OrderedSPIRegistry.getRegisteredServices(orderedSPIClass);
        LinkedHashMap result = new LinkedHashMap(registeredServices.size(), 1.0f);
        for (OrderedSPI each : registeredServices) {
            types.stream().filter(type -> each.getTypeClass() == type).forEach(type -> result.put(type, each));
        }
        return result;
    }

    public static <K, V extends OrderedSPI<?>> Map<K, V> getRegisteredServices(Collection<K> types, Class<V> orderedSPIClass) {
        Optional<CachedOrderedServices> cachedServices = OrderedServicesCache.findCachedServices(types, orderedSPIClass);
        if (cachedServices.isPresent()) {
            return cachedServices.get().getServices();
        }
        Collection<OrderedSPI> registeredServices = OrderedSPIRegistry.getRegisteredServices(orderedSPIClass);
        LinkedHashMap result = new LinkedHashMap(registeredServices.size(), 1.0f);
        for (OrderedSPI each : registeredServices) {
            types.stream().filter(type -> each.getTypeClass() == type.getClass()).forEach(type -> result.put(type, each));
        }
        OrderedServicesCache.cacheServices(types, orderedSPIClass, result);
        return result;
    }

    public static <T extends OrderedSPI<?>> Collection<T> getRegisteredServices(Class<T> orderedSPIClass) {
        TreeMap<Integer, OrderedSPI> result = new TreeMap<Integer, OrderedSPI>();
        for (OrderedSPI each : ShardingSphereServiceLoader.getSingletonServiceInstances(orderedSPIClass)) {
            Preconditions.checkArgument((!result.containsKey(each.getOrder()) ? 1 : 0) != 0, (String)"Found same order `%s` with `%s` and `%s`", (Object)each.getOrder(), result.get(each.getOrder()), (Object)each);
            result.put(each.getOrder(), each);
        }
        return result.values();
    }

    @Generated
    private OrderedSPIRegistry() {
    }
}

