/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.hint;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.infra.hint.SQLHintProperties;
import org.apache.shardingsphere.infra.hint.SQLHintPropertiesKey;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.AbstractSQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class SQLHintExtractor {
    private final SQLHintProperties sqlHintProperties;

    public SQLHintExtractor(SQLStatement sqlStatement) {
        this.sqlHintProperties = sqlStatement instanceof AbstractSQLStatement ? this.extract((AbstractSQLStatement)sqlStatement) : new SQLHintProperties(new Properties());
    }

    private SQLHintProperties extract(AbstractSQLStatement statement) {
        Properties properties = new Properties();
        for (CommentSegment each : statement.getCommentSegments()) {
            properties.putAll((Map<?, ?>)SQLHintUtils.getSQLHintProps(each.getText()));
        }
        return new SQLHintProperties(properties);
    }

    public Optional<String> findHintDataSourceName() {
        String result = (String)this.sqlHintProperties.getValue(SQLHintPropertiesKey.DATASOURCE_NAME_KEY);
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    public boolean isHintWriteRouteOnly() {
        return (Boolean)this.sqlHintProperties.getValue(SQLHintPropertiesKey.WRITE_ROUTE_ONLY_KEY);
    }
}

