/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import lombok.Generated;

public final class IpUtils {
    private static volatile String cachedIpAddress;

    public static String getIp() {
        Enumeration<NetworkInterface> netInterfaces;
        if (null != cachedIpAddress) {
            return cachedIpAddress;
        }
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            return "UnknownIP";
        }
        String localIpAddress = null;
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = netInterfaces.nextElement();
            Enumeration<InetAddress> ipAddresses = netInterface.getInetAddresses();
            while (ipAddresses.hasMoreElements()) {
                InetAddress ipAddress = ipAddresses.nextElement();
                if (IpUtils.isPublicIpAddress(ipAddress)) {
                    String publicIpAddress;
                    cachedIpAddress = publicIpAddress = ipAddress.getHostAddress();
                    return publicIpAddress;
                }
                if (!IpUtils.isLocalIpAddress(ipAddress)) continue;
                localIpAddress = ipAddress.getHostAddress();
            }
        }
        cachedIpAddress = localIpAddress;
        return localIpAddress;
    }

    private static boolean isPublicIpAddress(InetAddress ipAddress) {
        return !ipAddress.isSiteLocalAddress() && !ipAddress.isLoopbackAddress() && !IpUtils.isV6IpAddress(ipAddress);
    }

    private static boolean isLocalIpAddress(InetAddress ipAddress) {
        return ipAddress.isSiteLocalAddress() && !ipAddress.isLoopbackAddress() && !IpUtils.isV6IpAddress(ipAddress);
    }

    private static boolean isV6IpAddress(InetAddress ipAddress) {
        return ipAddress.getHostAddress().contains(":");
    }

    @Generated
    private IpUtils() {
    }
}

