/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.state;

import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.shardingsphere.infra.state.StateType;

public final class StateContext {
    private final Deque<StateType> currentState = new ConcurrentLinkedDeque<StateType>(Collections.singleton(StateType.OK));

    @Subscribe
    public void switchState(StateType type, boolean on) {
        if (on) {
            this.currentState.push(type);
        } else if (this.getCurrentState().equals((Object)type)) {
            this.recoverState();
        }
    }

    private void recoverState() {
        this.currentState.pop();
    }

    public StateType getCurrentState() {
        return Optional.ofNullable(this.currentState.peek()).orElse(StateType.OK);
    }
}

