/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.engine.representer;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.infra.yaml.engine.representer.processor.DefaultYamlTupleProcessor;
import org.apache.shardingsphere.infra.yaml.engine.representer.processor.ShardingSphereYamlTupleProcessor;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public final class ShardingSphereYamlRepresenter
extends Representer {
    public ShardingSphereYamlRepresenter() {
        YamlRuleConfigurationSwapperEngine.getYamlShortcuts().forEach((key, value) -> this.addClassTag((Class)value, new Tag(key)));
    }

    protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
        NodeTuple nodeTuple = super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        for (ShardingSphereYamlTupleProcessor each : ShardingSphereServiceLoader.getSingletonServiceInstances(ShardingSphereYamlTupleProcessor.class)) {
            if (!property.getName().equals(each.getTupleName())) continue;
            return each.process(nodeTuple);
        }
        return new DefaultYamlTupleProcessor().process(nodeTuple);
    }

    protected Node representMapping(Tag tag, Map<?, ?> mapping, Boolean flowStyle) {
        LinkedHashMap skippedEmptyValuesMapping = new LinkedHashMap(mapping.size(), 1.0f);
        for (Map.Entry<?, ?> entry : mapping.entrySet()) {
            if (entry.getValue() instanceof Collection && ((Collection)entry.getValue()).isEmpty() || entry.getValue() instanceof Map && ((Map)entry.getValue()).isEmpty()) continue;
            skippedEmptyValuesMapping.put(entry.getKey(), entry.getValue());
        }
        return super.representMapping(tag, skippedEmptyValuesMapping, flowStyle);
    }

    static {
        ShardingSphereServiceLoader.register(ShardingSphereYamlTupleProcessor.class);
    }
}

