/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.type.dialect;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.shardingsphere.infra.database.metadata.dialect.H2DataSourceMetaData;
import org.apache.shardingsphere.infra.database.type.BranchDatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.sql.parser.sql.common.enums.QuoteCharacter;

public final class H2DatabaseType
implements BranchDatabaseType {
    @Override
    public QuoteCharacter getQuoteCharacter() {
        return QuoteCharacter.QUOTE;
    }

    @Override
    public Collection<String> getJdbcUrlPrefixes() {
        return Collections.singleton(String.format("jdbc:%s:", this.getType().toLowerCase()));
    }

    @Override
    public H2DataSourceMetaData getDataSourceMetaData(String url, String username) {
        return new H2DataSourceMetaData(url);
    }

    @Override
    public DatabaseType getTrunkDatabaseType() {
        return (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (String)"MySQL");
    }

    @Override
    public Map<String, Collection<String>> getSystemDatabaseSchemaMap() {
        return Collections.emptyMap();
    }

    @Override
    public Collection<String> getSystemSchemas() {
        return Collections.emptyList();
    }

    public String getType() {
        return "H2";
    }
}

