/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.destroyer;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.detector.DataSourcePoolActiveDetector;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPILoader;

public final class DataSourcePoolDestroyer {
    private final DataSource dataSource;

    public void asyncDestroy() {
        if (!(this.dataSource instanceof AutoCloseable)) {
            return;
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(this::graceDestroy);
        executor.shutdown();
    }

    private void graceDestroy() {
        this.waitUntilActiveConnectionComplete();
        ((AutoCloseable)((Object)this.dataSource)).close();
    }

    private void waitUntilActiveConnectionComplete() {
        DataSourcePoolActiveDetector dataSourcePoolActiveDetector = (DataSourcePoolActiveDetector)TypedSPILoader.getService(DataSourcePoolActiveDetector.class, (String)this.dataSource.getClass().getName());
        while (dataSourcePoolActiveDetector.containsActiveConnection(this.dataSource)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Generated
    public DataSourcePoolDestroyer(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

