/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.hint;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.hint.SQLHintPropertiesKey;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;

public final class HintValueContext {
    private final Multimap<String, Comparable<?>> shardingDatabaseValues = ArrayListMultimap.create();
    private final Multimap<String, Comparable<?>> shardingTableValues = ArrayListMultimap.create();
    private String dataSourceName = "";
    private boolean databaseShardingOnly;
    private boolean writeRouteOnly;
    private boolean useTraffic;
    private boolean skipSQLRewrite;
    private String disableAuditNames = "";
    private boolean shadow;

    public Collection<String> findDisableAuditNames() {
        return SQLHintUtils.getSplitterSQLHintValue(this.disableAuditNames);
    }

    public Optional<String> findHintDataSourceName() {
        return this.dataSourceName.isEmpty() ? Optional.empty() : Optional.of(this.dataSourceName);
    }

    public boolean containsHintShardingDatabaseValue(String tableName) {
        String key = Joiner.on((String)".").join((Object)tableName.toUpperCase(), (Object)SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY.getKey(), new Object[0]);
        return this.shardingDatabaseValues.containsKey((Object)key) || this.shardingDatabaseValues.containsKey((Object)SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY.getKey());
    }

    public boolean containsHintShardingTableValue(String tableName) {
        String key = Joiner.on((String)".").join((Object)tableName.toUpperCase(), (Object)SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY.getKey(), new Object[0]);
        return this.shardingTableValues.containsKey((Object)key) || this.shardingTableValues.containsKey((Object)SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY.getKey());
    }

    public boolean containsHintShardingValue(String tableName) {
        return this.containsHintShardingDatabaseValue(tableName) || this.containsHintShardingTableValue(tableName);
    }

    public Collection<Comparable<?>> getHintShardingTableValue(String tableName) {
        String key = String.join((CharSequence)".", tableName.toUpperCase(), SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY.getKey());
        return this.shardingTableValues.containsKey((Object)key) ? this.shardingTableValues.get((Object)key) : this.shardingTableValues.get((Object)SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY.getKey());
    }

    public Collection<Comparable<?>> getHintShardingDatabaseValue(String tableName) {
        String key = String.join((CharSequence)".", tableName.toUpperCase(), SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY.getKey());
        return this.shardingDatabaseValues.containsKey((Object)key) ? this.shardingDatabaseValues.get((Object)key) : this.shardingDatabaseValues.get((Object)SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY.getKey());
    }

    @Generated
    public Multimap<String, Comparable<?>> getShardingDatabaseValues() {
        return this.shardingDatabaseValues;
    }

    @Generated
    public Multimap<String, Comparable<?>> getShardingTableValues() {
        return this.shardingTableValues;
    }

    @Generated
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Generated
    public boolean isDatabaseShardingOnly() {
        return this.databaseShardingOnly;
    }

    @Generated
    public boolean isWriteRouteOnly() {
        return this.writeRouteOnly;
    }

    @Generated
    public boolean isUseTraffic() {
        return this.useTraffic;
    }

    @Generated
    public boolean isSkipSQLRewrite() {
        return this.skipSQLRewrite;
    }

    @Generated
    public String getDisableAuditNames() {
        return this.disableAuditNames;
    }

    @Generated
    public boolean isShadow() {
        return this.shadow;
    }

    @Generated
    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    @Generated
    public void setDatabaseShardingOnly(boolean databaseShardingOnly) {
        this.databaseShardingOnly = databaseShardingOnly;
    }

    @Generated
    public void setWriteRouteOnly(boolean writeRouteOnly) {
        this.writeRouteOnly = writeRouteOnly;
    }

    @Generated
    public void setUseTraffic(boolean useTraffic) {
        this.useTraffic = useTraffic;
    }

    @Generated
    public void setSkipSQLRewrite(boolean skipSQLRewrite) {
        this.skipSQLRewrite = skipSQLRewrite;
    }

    @Generated
    public void setDisableAuditNames(String disableAuditNames) {
        this.disableAuditNames = disableAuditNames;
    }

    @Generated
    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    @Generated
    public String toString() {
        return "HintValueContext(shardingDatabaseValues=" + this.getShardingDatabaseValues() + ", shardingTableValues=" + this.getShardingTableValues() + ", dataSourceName=" + this.getDataSourceName() + ", databaseShardingOnly=" + this.isDatabaseShardingOnly() + ", writeRouteOnly=" + this.isWriteRouteOnly() + ", useTraffic=" + this.isUseTraffic() + ", skipSQLRewrite=" + this.isSkipSQLRewrite() + ", disableAuditNames=" + this.getDisableAuditNames() + ", shadow=" + this.isShadow() + ")";
    }
}

