/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.hint;

import com.google.common.base.Splitter;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintPropertiesKey;
import org.apache.shardingsphere.infra.hint.SQLHintTokenEnum;

public final class SQLHintUtils {
    private static final String SQL_COMMENT_SUFFIX = "*/";
    private static final String SQL_HINT_SPLIT = ",";
    private static final String SQL_HINT_VALUE_SPLIT = "=";
    private static final String SQL_HINT_VALUE_COLLECTION_SPLIT = " ";
    private static final int SQL_HINT_VALUE_SIZE = 2;

    public static Properties getSQLHintProps(String comment) {
        int startIndex;
        Properties result = new Properties();
        String lowerCaseComment = comment.toLowerCase();
        int n = startIndex = lowerCaseComment.startsWith(SQLHintTokenEnum.SQL_START_HINT_TOKEN.getAlias().toLowerCase()) ? lowerCaseComment.indexOf(SQLHintTokenEnum.SQL_HINT_TOKEN.getAlias()) : lowerCaseComment.indexOf(SQLHintTokenEnum.SQL_HINT_TOKEN.getKey());
        if (startIndex < 0) {
            return result;
        }
        int endIndex = comment.endsWith(SQL_COMMENT_SUFFIX) ? comment.indexOf(SQL_COMMENT_SUFFIX) : comment.length();
        List sqlHints = Splitter.on((String)SQL_HINT_SPLIT).trimResults().splitToList((CharSequence)comment.substring(startIndex += SQLHintTokenEnum.SQL_HINT_TOKEN.getKey().length(), endIndex).trim());
        for (String each : sqlHints) {
            List hintValues = Splitter.on((String)SQL_HINT_VALUE_SPLIT).trimResults().splitToList((CharSequence)each);
            if (2 != hintValues.size()) continue;
            result.put(hintValues.get(0), SQLHintUtils.convert((String)hintValues.get(1)));
        }
        return result;
    }

    private static Object convert(String value) {
        try {
            return new BigInteger(value);
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    public static Collection<String> getSplitterSQLHintValue(String value) {
        return value.isEmpty() ? Collections.emptySet() : new HashSet(Splitter.on((String)SQL_HINT_VALUE_COLLECTION_SPLIT).omitEmptyStrings().trimResults().splitToList((CharSequence)value));
    }

    public static Optional<HintValueContext> extractHint(String sql) {
        if (!SQLHintUtils.startWithHint(sql)) {
            return Optional.empty();
        }
        HintValueContext result = new HintValueContext();
        String hintText = sql.substring(0, sql.indexOf(SQL_COMMENT_SUFFIX) + 2);
        Properties hintProperties = SQLHintUtils.getSQLHintProps(hintText);
        if (SQLHintUtils.containsPropertyKey(hintProperties, SQLHintPropertiesKey.DATASOURCE_NAME_KEY)) {
            result.setDataSourceName(SQLHintUtils.getProperty(hintProperties, SQLHintPropertiesKey.DATASOURCE_NAME_KEY));
        }
        if (SQLHintUtils.containsPropertyKey(hintProperties, SQLHintPropertiesKey.WRITE_ROUTE_ONLY_KEY)) {
            result.setWriteRouteOnly(Boolean.parseBoolean(SQLHintUtils.getProperty(hintProperties, SQLHintPropertiesKey.WRITE_ROUTE_ONLY_KEY)));
        }
        if (SQLHintUtils.containsPropertyKey(hintProperties, SQLHintPropertiesKey.USE_TRAFFIC_KEY)) {
            result.setUseTraffic(Boolean.parseBoolean(SQLHintUtils.getProperty(hintProperties, SQLHintPropertiesKey.USE_TRAFFIC_KEY)));
        }
        if (SQLHintUtils.containsPropertyKey(hintProperties, SQLHintPropertiesKey.SKIP_SQL_REWRITE_KEY)) {
            result.setSkipSQLRewrite(Boolean.parseBoolean(SQLHintUtils.getProperty(hintProperties, SQLHintPropertiesKey.SKIP_SQL_REWRITE_KEY)));
        }
        if (SQLHintUtils.containsPropertyKey(hintProperties, SQLHintPropertiesKey.DISABLE_AUDIT_NAMES_KEY)) {
            result.setDisableAuditNames(SQLHintUtils.getProperty(hintProperties, SQLHintPropertiesKey.DISABLE_AUDIT_NAMES_KEY));
        }
        if (SQLHintUtils.containsPropertyKey(hintProperties, SQLHintPropertiesKey.SHADOW_KEY)) {
            result.setShadow(Boolean.parseBoolean(SQLHintUtils.getProperty(hintProperties, SQLHintPropertiesKey.SHADOW_KEY)));
        }
        for (Map.Entry<Object, Object> entry : hintProperties.entrySet()) {
            Object value;
            Object object = value = entry.getValue() instanceof Comparable ? (Comparable)entry.getValue() : Objects.toString(entry.getValue());
            if (SQLHintUtils.containsPropertyKey(Objects.toString(entry.getKey()), SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY)) {
                result.getShardingDatabaseValues().put((Object)Objects.toString(entry.getKey()).toUpperCase(), value);
            }
            if (!SQLHintUtils.containsPropertyKey(Objects.toString(entry.getKey()), SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY)) continue;
            result.getShardingTableValues().put((Object)Objects.toString(entry.getKey()).toUpperCase(), value);
        }
        return Optional.of(result);
    }

    private static boolean startWithHint(String sql) {
        return null != sql && (sql.startsWith(SQLHintTokenEnum.SQL_START_HINT_TOKEN.getKey()) || sql.startsWith(SQLHintTokenEnum.SQL_START_HINT_TOKEN.getAlias()));
    }

    private static boolean containsPropertyKey(Properties hintProperties, SQLHintPropertiesKey sqlHintPropertiesKey) {
        return hintProperties.containsKey(sqlHintPropertiesKey.getKey()) || hintProperties.containsKey(sqlHintPropertiesKey.getAlias());
    }

    private static boolean containsPropertyKey(String hintPropertyKey, SQLHintPropertiesKey sqlHintPropertiesKey) {
        return hintPropertyKey.contains(sqlHintPropertiesKey.getKey()) || hintPropertyKey.contains(sqlHintPropertiesKey.getAlias());
    }

    private static String getProperty(Properties hintProperties, SQLHintPropertiesKey sqlHintPropertiesKey) {
        String result = hintProperties.getProperty(sqlHintPropertiesKey.getKey());
        return null == result ? hintProperties.getProperty(sqlHintPropertiesKey.getAlias()) : result;
    }

    public static String removeHint(String sql) {
        if (SQLHintUtils.startWithHint(sql)) {
            return sql.substring(sql.indexOf(SQL_COMMENT_SUFFIX) + 2);
        }
        return sql;
    }

    @Generated
    private SQLHintUtils() {
    }
}

