/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.nodepath.root;

import java.util.regex.Pattern;
import lombok.Generated;

public final class RuleRootNodePath {
    private static final String RULE_NODE_PREFIX = "/[\\w\\-]+/[\\w\\-]+/rules/";
    private final String ruleType;
    private final String nodePrefix;
    private final Pattern pathPattern;

    public RuleRootNodePath(String ruleType) {
        this.ruleType = ruleType;
        this.nodePrefix = RULE_NODE_PREFIX + ruleType + "/";
        this.pathPattern = Pattern.compile(this.nodePrefix + ".*");
    }

    public boolean isValidatedPath(String path) {
        return this.pathPattern.matcher(path).find();
    }

    @Generated
    public String getRuleType() {
        return this.ruleType;
    }

    @Generated
    public String getNodePrefix() {
        return this.nodePrefix;
    }
}

