/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rule.builder.database;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.infra.config.rule.function.DistributedRuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.function.EnhancedRuleConfiguration;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.database.DatabaseRuleBuilder;
import org.apache.shardingsphere.infra.rule.builder.database.DefaultDatabaseRuleConfigurationBuilder;
import org.apache.shardingsphere.infra.util.spi.type.ordered.OrderedSPILoader;

public final class DatabaseRulesBuilder {
    public static Collection<ShardingSphereRule> build(String databaseName, DatabaseConfiguration databaseConfig, InstanceContext instanceContext) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        for (Map.Entry<RuleConfiguration, DatabaseRuleBuilder> entry : DatabaseRulesBuilder.getRuleBuilderMap(databaseConfig).entrySet()) {
            RuleConfigurationChecker configChecker = (RuleConfigurationChecker)OrderedSPILoader.getServicesByClass(RuleConfigurationChecker.class, Collections.singleton(entry.getKey().getClass())).get(entry.getKey().getClass());
            if (null != configChecker) {
                configChecker.check(databaseName, entry.getKey(), databaseConfig.getDataSources(), result);
            }
            result.add(entry.getValue().build(entry.getKey(), databaseName, databaseConfig.getDataSources(), result, instanceContext));
        }
        return result;
    }

    public static Collection<ShardingSphereRule> build(String databaseName, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> rules, RuleConfiguration ruleConfigs, InstanceContext instanceContext) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        for (Map.Entry entry : OrderedSPILoader.getServices(DatabaseRuleBuilder.class, Collections.singletonList(ruleConfigs), Comparator.reverseOrder()).entrySet()) {
            RuleConfigurationChecker configChecker = (RuleConfigurationChecker)OrderedSPILoader.getServicesByClass(RuleConfigurationChecker.class, Collections.singleton(((RuleConfiguration)entry.getKey()).getClass())).get(((RuleConfiguration)entry.getKey()).getClass());
            if (null != configChecker) {
                configChecker.check(databaseName, (RuleConfiguration)entry.getKey(), dataSources, rules);
            }
            result.add(((DatabaseRuleBuilder)entry.getValue()).build((RuleConfiguration)entry.getKey(), databaseName, dataSources, rules, instanceContext));
        }
        return result;
    }

    private static Map<RuleConfiguration, DatabaseRuleBuilder> getRuleBuilderMap(DatabaseConfiguration databaseConfig) {
        LinkedHashMap<RuleConfiguration, DatabaseRuleBuilder> result = new LinkedHashMap<RuleConfiguration, DatabaseRuleBuilder>();
        result.putAll(DatabaseRulesBuilder.getDistributedRuleBuilderMap(databaseConfig.getRuleConfigurations()));
        result.putAll(DatabaseRulesBuilder.getEnhancedRuleBuilderMap(databaseConfig.getRuleConfigurations()));
        result.putAll(DatabaseRulesBuilder.getMissedDefaultRuleBuilderMap(result.values()));
        return result;
    }

    private static Map<RuleConfiguration, DatabaseRuleBuilder> getDistributedRuleBuilderMap(Collection<RuleConfiguration> ruleConfigs) {
        Collection distributedRuleConfigs = ruleConfigs.stream().filter(each -> DatabaseRulesBuilder.isAssignableFrom(each, DistributedRuleConfiguration.class)).collect(Collectors.toList());
        return OrderedSPILoader.getServices(DatabaseRuleBuilder.class, (Collection)distributedRuleConfigs, Comparator.reverseOrder());
    }

    private static Map<RuleConfiguration, DatabaseRuleBuilder> getEnhancedRuleBuilderMap(Collection<RuleConfiguration> ruleConfigs) {
        Collection enhancedRuleConfigs = ruleConfigs.stream().filter(each -> DatabaseRulesBuilder.isAssignableFrom(each, EnhancedRuleConfiguration.class)).collect(Collectors.toList());
        return OrderedSPILoader.getServices(DatabaseRuleBuilder.class, (Collection)enhancedRuleConfigs);
    }

    private static boolean isAssignableFrom(RuleConfiguration ruleConfig, Class<? extends RuleConfiguration> ruleConfigClass) {
        return Arrays.stream(ruleConfig.getClass().getInterfaces()).anyMatch(ruleConfigClass::isAssignableFrom);
    }

    private static Map<RuleConfiguration, DatabaseRuleBuilder> getMissedDefaultRuleBuilderMap(Collection<DatabaseRuleBuilder> configuredBuilders) {
        LinkedHashMap<RuleConfiguration, DatabaseRuleBuilder> result = new LinkedHashMap<RuleConfiguration, DatabaseRuleBuilder>();
        Map defaultBuilders = OrderedSPILoader.getServices(DefaultDatabaseRuleConfigurationBuilder.class, DatabaseRulesBuilder.getMissedDefaultRuleBuilders(configuredBuilders));
        for (Map.Entry entry : defaultBuilders.entrySet()) {
            result.put((RuleConfiguration)((DefaultDatabaseRuleConfigurationBuilder)entry.getValue()).build(), (DatabaseRuleBuilder)entry.getKey());
        }
        return result;
    }

    private static Collection<DatabaseRuleBuilder> getMissedDefaultRuleBuilders(Collection<DatabaseRuleBuilder> configuredBuilders) {
        Collection configuredBuilderClasses = configuredBuilders.stream().map(each -> each.getClass()).collect(Collectors.toSet());
        return OrderedSPILoader.getServices(DatabaseRuleBuilder.class).stream().filter(each -> !configuredBuilderClasses.contains(each.getClass())).collect(Collectors.toList());
    }

    @Generated
    private DatabaseRulesBuilder() {
    }
}

