/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rule.identifier.type.exportable;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.rule.identifier.type.exportable.ExportableRule;

public final class RuleExportEngine {
    private final ExportableRule rule;

    public Map<String, Object> export(Collection<String> keys) {
        Map<String, Object> exportMethods = this.rule.getExportData();
        HashMap<String, Object> result = new HashMap<String, Object>(keys.size(), 1.0f);
        keys.forEach(each -> {
            if (exportMethods.containsKey(each)) {
                result.put((String)each, exportMethods.get(each));
            }
        });
        return result;
    }

    public Optional<Object> export(String key) {
        return Optional.ofNullable(this.rule.getExportData().get(key));
    }

    public boolean containExportableKey(Collection<String> keys) {
        return keys.stream().anyMatch(each -> this.rule.getExportData().containsKey(each));
    }

    @Generated
    public RuleExportEngine(ExportableRule rule) {
        this.rule = rule;
    }
}

