/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.connection.refresher.type.schema;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.connection.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.instance.mode.ModeContextManager;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class DropSchemaStatementSchemaRefresher
implements MetaDataRefresher<DropSchemaStatement> {
    @Override
    public void refresh(ModeContextManager modeContextManager, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DropSchemaStatement sqlStatement, ConfigurationProperties props) {
        modeContextManager.dropSchema(database.getName(), this.getSchemaNames(sqlStatement));
    }

    private Collection<String> getSchemaNames(DropSchemaStatement sqlStatement) {
        LinkedList<String> result = new LinkedList<String>();
        for (IdentifierValue each : sqlStatement.getSchemaNames()) {
            result.add(each.getValue().toLowerCase());
        }
        return result;
    }

    public String getType() {
        return DropSchemaStatement.class.getName();
    }
}

