/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.connection.refresher.type.table;

import java.util.Collection;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.connection.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.connection.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.infra.instance.mode.ModeContextManager;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropTableStatement;

public final class DropTableStatementSchemaRefresher
implements MetaDataRefresher<DropTableStatement> {
    @Override
    public void refresh(ModeContextManager modeContextManager, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DropTableStatement sqlStatement, ConfigurationProperties props) {
        AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO = new AlterSchemaMetaDataPOJO(database.getName(), schemaName);
        sqlStatement.getTables().forEach(each -> alterSchemaMetaDataPOJO.getDroppedTables().add(each.getTableName().getIdentifier().getValue()));
        modeContextManager.alterSchemaMetaData(alterSchemaMetaDataPOJO);
        ShardingSphereRuleMetaData ruleMetaData = database.getRuleMetaData();
        for (SimpleTableSegment each2 : sqlStatement.getTables()) {
            String tableName = each2.getTableName().getIdentifier().getValue();
            if (!this.isSingleTable(tableName, ruleMetaData) || !TableRefreshUtils.isRuleRefreshRequired(ruleMetaData, schemaName, tableName)) continue;
            modeContextManager.alterRuleConfiguration(database.getName(), ruleMetaData.getConfigurations());
            break;
        }
    }

    private boolean isSingleTable(String tableName, ShardingSphereRuleMetaData ruleMetaData) {
        return ruleMetaData.findRules(TableContainedRule.class).stream().noneMatch(each -> each.getDistributedTableMapper().contains(tableName));
    }

    public String getType() {
        return DropTableStatement.class.getName();
    }
}

