/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.connection.refresher.util;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.single.api.config.SingleRuleConfiguration;

public final class TableRefreshUtils {
    public static boolean isRuleRefreshRequired(ShardingSphereRuleMetaData ruleMetaData, String schemaName, String tableName) {
        Optional singleRule = ruleMetaData.findSingleRule(MutableDataNodeRule.class);
        if (!singleRule.isPresent()) {
            return false;
        }
        RuleConfiguration ruleConfiguration = ((MutableDataNodeRule)singleRule.get()).getConfiguration();
        if (!(ruleConfiguration instanceof SingleRuleConfiguration)) {
            return false;
        }
        Collection tablesConfig = ((SingleRuleConfiguration)ruleConfiguration).getTables();
        if (tablesConfig.contains("*.*") || tablesConfig.contains("*.*.*")) {
            return false;
        }
        Optional dataNode = ((MutableDataNodeRule)singleRule.get()).findTableDataNode(schemaName, tableName);
        if (!dataNode.isPresent()) {
            return false;
        }
        DataNode actualNode = (DataNode)dataNode.get();
        return !tablesConfig.contains(TableRefreshUtils.joinDataNodeSegments(actualNode.getDataSourceName(), "*")) && !tablesConfig.contains(TableRefreshUtils.joinDataNodeSegments(actualNode.getDataSourceName(), "*", "*")) && !tablesConfig.contains(TableRefreshUtils.joinDataNodeSegments(actualNode.getDataSourceName(), actualNode.getSchemaName(), "*"));
    }

    private static String joinDataNodeSegments(String ... segments) {
        return Joiner.on((String)".").join((Object[])segments);
    }

    @Generated
    private TableRefreshUtils() {
    }
}

