/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.opengauss.checker;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.checker.DialectDatabasePrivilegeChecker;
import org.apache.shardingsphere.infra.database.core.checker.PrivilegeCheckType;
import org.apache.shardingsphere.infra.database.core.exception.CheckDatabaseEnvironmentFailedException;
import org.apache.shardingsphere.infra.database.core.exception.MissingRequiredPrivilegeException;
import org.apache.shardingsphere.infra.database.core.exception.MissingRequiredUserException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGaussDatabasePrivilegeChecker
implements DialectDatabasePrivilegeChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenGaussDatabasePrivilegeChecker.class);
    private static final String SHOW_GRANTS_SQL = "SELECT * FROM pg_roles WHERE rolname = ?";

    public void check(DataSource dataSource, PrivilegeCheckType privilegeCheckType) {
        if (PrivilegeCheckType.PIPELINE != privilegeCheckType) {
            return;
        }
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(SHOW_GRANTS_SQL);){
            DatabaseMetaData metaData = connection.getMetaData();
            preparedStatement.setString(1, metaData.getUserName());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                String username = metaData.getUserName();
                ShardingSpherePreconditions.checkState((boolean)resultSet.next(), () -> new MissingRequiredUserException(username));
                String isSuperRole = resultSet.getString("rolsuper");
                String isReplicationRole = resultSet.getString("rolreplication");
                String isSystemAdminRole = resultSet.getString("rolsystemadmin");
                ShardingSpherePreconditions.checkState(("t".equalsIgnoreCase(isSuperRole) || "t".equalsIgnoreCase(isReplicationRole) || "t".equalsIgnoreCase(isSystemAdminRole) ? 1 : 0) != 0, () -> new MissingRequiredPrivilegeException(Collections.singleton("REPLICATION")));
            }
        }
        catch (SQLException ex) {
            throw new CheckDatabaseEnvironmentFailedException(ex);
        }
    }

    public String getDatabaseType() {
        return "openGauss";
    }
}

