/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.vertx;

import io.vertx.core.Future;
import io.vertx.mysqlclient.MySQLClient;
import io.vertx.mysqlclient.impl.protocol.ColumnDefinition;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.vertx.VertxExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.vertx.VertxMySQLQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.vertx.VertxQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;

public final class VertxExecutorCallback
implements ExecutorCallback<VertxExecutionUnit, Future<ExecuteResult>> {
    @Override
    public Collection<Future<ExecuteResult>> execute(Collection<VertxExecutionUnit> inputs, boolean isTrunkThread, Map<String, Object> dataMap) throws SQLException {
        ArrayList<Future<ExecuteResult>> result = new ArrayList<Future<ExecuteResult>>(inputs.size());
        for (VertxExecutionUnit each : inputs) {
            Future future = each.getStorageResource().compose(preparedQuery -> preparedQuery.execute(Tuple.from(each.getExecutionUnit().getSqlUnit().getParameters())));
            result.add((Future<ExecuteResult>)future.compose(this::handleResult));
        }
        return result;
    }

    private Future<ExecuteResult> handleResult(RowSet<Row> rowSet) {
        if (null == rowSet.columnDescriptors()) {
            return Future.succeededFuture((Object)new UpdateResult(rowSet.rowCount(), this.getGeneratedKey(rowSet)));
        }
        ArrayList<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>(rowSet.columnDescriptors().size());
        rowSet.columnDescriptors().forEach(each -> columnDefinitions.add((ColumnDefinition)each));
        return Future.succeededFuture((Object)new VertxQueryResult(new VertxMySQLQueryResultMetaData(columnDefinitions), (Iterator<Row>)rowSet.iterator()));
    }

    private long getGeneratedKey(RowSet<Row> rowSet) {
        Long result = (Long)rowSet.property(MySQLClient.LAST_INSERTED_ID);
        return null == result ? 0L : result;
    }
}

