/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;

public abstract class AbstractMemoryQueryResult
implements QueryResult {
    private final QueryResultMetaData metaData;
    private final Iterator<MemoryQueryResultDataRow> rows;
    private MemoryQueryResultDataRow currentRow;
    private long rowCount;
    private boolean wasNull;

    protected AbstractMemoryQueryResult(QueryResultMetaData metaData, Collection<MemoryQueryResultDataRow> rows) {
        this.metaData = metaData;
        this.rows = rows.iterator();
        this.rowCount = rows.size();
    }

    @Override
    public final boolean next() {
        if (this.rows.hasNext()) {
            this.currentRow = this.rows.next();
            --this.rowCount;
            return true;
        }
        this.currentRow = null;
        return false;
    }

    @Override
    public final Object getValue(int columnIndex, Class<?> type) {
        Object result = this.currentRow.getValue().get(columnIndex - 1);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public final Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        Object result = this.currentRow.getValue().get(columnIndex - 1);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public final InputStream getInputStream(int columnIndex, String type) {
        Object value = this.currentRow.getValue().get(columnIndex - 1);
        this.wasNull = null == value;
        return this.getInputStream(value);
    }

    private InputStream getInputStream(Object value) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(value);
        objectOutputStream.flush();
        objectOutputStream.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return new BufferedReader(new InputStreamReader(this.getInputStream(columnIndex)));
    }

    @Override
    public final boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public final void close() {
    }

    @Override
    @Generated
    public QueryResultMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public MemoryQueryResultDataRow getCurrentRow() {
        return this.currentRow;
    }

    @Generated
    public long getRowCount() {
        return this.rowCount;
    }
}

