/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.executor.customized;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.calcite.interpreter.InterpretableConvention;
import org.apache.calcite.interpreter.InterpretableConverter;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.type.dialect.H2DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.federation.executor.FederationContext;
import org.apache.shardingsphere.infra.federation.executor.FederationExecutor;
import org.apache.shardingsphere.infra.federation.executor.customized.CustomizedFilterableExecuteDataContext;
import org.apache.shardingsphere.infra.federation.executor.customized.FederationResultSet;
import org.apache.shardingsphere.infra.federation.optimizer.ShardingSphereOptimizer;
import org.apache.shardingsphere.infra.federation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.enumerable.EnumerableMergedResult;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class CustomizedFilterableExecutor
implements FederationExecutor {
    private final String databaseName;
    private final String schemaName;
    private final ShardingSphereOptimizer optimizer;
    private ResultSet federationResultSet;

    public CustomizedFilterableExecutor(String databaseName, String schemaName, OptimizerContext context) {
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.optimizer = new ShardingSphereOptimizer(context);
    }

    @Override
    public ResultSet executeQuery(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, FederationContext federationContext) throws SQLException {
        String sql = federationContext.getLogicSQL().getSql();
        ShardingSphereSQLParserEngine sqlParserEngine = new ShardingSphereSQLParserEngine(DatabaseTypeEngine.getTrunkDatabaseTypeName((DatabaseType)new H2DatabaseType()), new CacheOption(1, 1L), new CacheOption(1, 1L), false);
        SQLStatement sqlStatement = sqlParserEngine.parse(sql, false);
        Enumerable<Object[]> enumerableResult = this.execute(sqlStatement);
        EnumerableMergedResult mergedResult = new EnumerableMergedResult(enumerableResult);
        this.federationResultSet = new FederationResultSet((MergedResult)mergedResult);
        return this.federationResultSet;
    }

    @Override
    public ResultSet getResultSet() {
        return this.federationResultSet;
    }

    private Enumerable<Object[]> execute(SQLStatement sqlStatement) {
        return this.execute(this.optimizer.optimize(this.databaseName, this.schemaName, sqlStatement));
    }

    private Enumerable<Object[]> execute(RelNode bestPlan) {
        RelOptCluster cluster = ((SqlToRelConverter)((OptimizerPlannerContext)this.optimizer.getContext().getPlannerContexts().get(this.databaseName)).getConverters().get(this.schemaName)).getCluster();
        return new FederateInterpretableConverter(cluster, cluster.traitSetOf((RelTrait)InterpretableConvention.INSTANCE), bestPlan).bind(new CustomizedFilterableExecuteDataContext(this.databaseName, this.schemaName, this.optimizer.getContext()));
    }

    @Override
    public void close() {
    }

    public static final class FederateInterpretableConverter
    extends InterpretableConverter {
        public FederateInterpretableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
            super(cluster, traits, input);
        }
    }
}

