/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.spi;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.spi.annotation.SingletonSPI;

public final class ShardingSphereServiceLoader<T> {
    private static final Map<Class<?>, ShardingSphereServiceLoader<?>> LOADERS = new ConcurrentHashMap();
    private static final int LOAD_LOCKS_COUNT = 16;
    private static final Object[] LOAD_LOCKS = new Object[16];
    private final Class<T> serviceInterface;
    private final Collection<T> services;

    private ShardingSphereServiceLoader(Class<T> serviceInterface) {
        this.serviceInterface = serviceInterface;
        this.validate();
        this.services = this.load();
    }

    private void validate() {
        Preconditions.checkNotNull(this.serviceInterface, (Object)"SPI interface is null.");
        Preconditions.checkArgument((boolean)this.serviceInterface.isInterface(), (String)"SPI interface `%s` is not interface.", this.serviceInterface);
    }

    private Collection<T> load() {
        LinkedList<T> result = new LinkedList<T>();
        for (T each : ServiceLoader.load(this.serviceInterface)) {
            result.add(each);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Collection<T> getServiceInstances(Class<T> serviceInterface) {
        ShardingSphereServiceLoader<Object> result = LOADERS.get(serviceInterface);
        if (null != result) {
            return super.getServiceInstances();
        }
        Object object = LOAD_LOCKS[serviceInterface.hashCode() % 16];
        synchronized (object) {
            result = LOADERS.get(serviceInterface);
            if (null == result) {
                result = new ShardingSphereServiceLoader<T>(serviceInterface);
                LOADERS.put(serviceInterface, result);
            }
        }
        return super.getServiceInstances();
    }

    private Collection<T> getServiceInstances() {
        return null == this.serviceInterface.getAnnotation(SingletonSPI.class) ? this.createNewServiceInstances() : this.getSingletonServiceInstances();
    }

    private Collection<T> createNewServiceInstances() {
        LinkedList result = new LinkedList();
        for (T each : this.services) {
            result.add(each.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        return result;
    }

    private Collection<T> getSingletonServiceInstances() {
        return this.services;
    }

    @Generated
    public Collection<T> getServices() {
        return this.services;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            ShardingSphereServiceLoader.LOAD_LOCKS[i] = new Object();
        }
    }
}

