/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.loadbalancer.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.MapUtils;
import org.apache.shenyu.common.utils.UpstreamCheckUtils;
import org.apache.shenyu.loadbalancer.cache.UpstreamWithSelectorId;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpstreamCheckTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(UpstreamCheckTask.class);
    private final Map<String, List<Upstream>> healthyUpstream = Maps.newConcurrentMap();
    private final Map<String, List<Upstream>> unhealthyUpstream = Maps.newConcurrentMap();
    private final Object lock = new Object();
    private final AtomicBoolean checkStarted = new AtomicBoolean(false);
    private final List<CompletableFuture<UpstreamWithSelectorId>> futures = Lists.newArrayList();
    private final int checkInterval;
    private ExecutorService executor;
    private int poolSize;
    private int checkTimeout = 3000;
    private int healthyThreshold = 1;
    private int unhealthyThreshold = 1;

    public UpstreamCheckTask(int checkInterval) {
        this.checkInterval = checkInterval;
    }

    public AtomicBoolean getCheckStarted() {
        return this.checkStarted;
    }

    public void schedule() {
        ThreadFactory healthCheckFactory = ShenyuThreadFactory.create((String)"upstream-health-check", (boolean)true);
        new ScheduledThreadPoolExecutor(1, healthCheckFactory).scheduleWithFixedDelay(this, 3000L, this.checkInterval, TimeUnit.MILLISECONDS);
        ThreadFactory requestFactory = ShenyuThreadFactory.create((String)"upstream-health-check-request", (boolean)true);
        this.executor = new ScheduledThreadPoolExecutor(this.poolSize, requestFactory);
    }

    public void setCheckTimeout(int checkTimeout) {
        this.checkTimeout = checkTimeout;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setHealthyThreshold(int healthyThreshold) {
        this.healthyThreshold = healthyThreshold;
    }

    public void setUnhealthyThreshold(int unhealthyThreshold) {
        this.unhealthyThreshold = unhealthyThreshold;
    }

    @Override
    public void run() {
        this.healthCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void healthCheck() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.tryStartHealthCheck()) {
                    this.doHealthCheck();
                    this.waitFinish();
                }
            }
        }
        catch (Exception e) {
            LOG.error("[Health Check] Meet problem: ", (Throwable)e);
        }
        finally {
            this.finishHealthCheck();
        }
    }

    private void doHealthCheck() {
        this.check(this.healthyUpstream);
        this.check(this.unhealthyUpstream);
    }

    private void check(Map<String, List<Upstream>> map) {
        for (Map.Entry<String, List<Upstream>> entry : map.entrySet()) {
            String key = entry.getKey();
            List<Upstream> value = entry.getValue();
            for (Upstream upstream : value) {
                CompletableFuture<UpstreamWithSelectorId> future = CompletableFuture.supplyAsync(() -> this.check(key, upstream), this.executor);
                this.futures.add(future);
            }
        }
    }

    private UpstreamWithSelectorId check(String selectorId, Upstream upstream) {
        boolean pass = UpstreamCheckUtils.checkUrl((String)upstream.getUrl(), (int)this.checkTimeout);
        if (pass) {
            if (upstream.isHealthy()) {
                upstream.setLastHealthTimestamp(System.currentTimeMillis());
            } else {
                long now = System.currentTimeMillis();
                long interval = now - upstream.getLastUnhealthyTimestamp();
                if (interval >= (long)this.checkInterval * (long)this.healthyThreshold) {
                    upstream.setHealthy(true);
                    upstream.setLastHealthTimestamp(now);
                    LOG.info("[Health Check] Selector [{}] upstream {} health check passed, server is back online.", (Object)selectorId, (Object)upstream.getUrl());
                }
            }
        } else if (!upstream.isHealthy()) {
            upstream.setLastUnhealthyTimestamp(System.currentTimeMillis());
        } else {
            long now = System.currentTimeMillis();
            long interval = now - upstream.getLastHealthTimestamp();
            if (interval >= (long)this.checkInterval * (long)this.unhealthyThreshold) {
                upstream.setHealthy(false);
                upstream.setLastUnhealthyTimestamp(now);
                LOG.info("[Health Check] Selector [{}] upstream {} health check failed, server is offline.", (Object)selectorId, (Object)upstream.getUrl());
            }
        }
        return new UpstreamWithSelectorId(selectorId, upstream);
    }

    private boolean tryStartHealthCheck() {
        return this.checkStarted.compareAndSet(false, true);
    }

    private void waitFinish() throws ExecutionException, InterruptedException {
        for (CompletableFuture<UpstreamWithSelectorId> future : this.futures) {
            UpstreamWithSelectorId entity = future.get();
            this.putEntityToMap(entity);
        }
        this.futures.clear();
    }

    private void putEntityToMap(UpstreamWithSelectorId entity) {
        Upstream upstream = entity.getUpstream();
        if (upstream.isHealthy()) {
            this.putToMap(this.healthyUpstream, entity.getSelectorId(), upstream);
            this.removeFromMap(this.unhealthyUpstream, entity.getSelectorId(), upstream);
        } else {
            this.putToMap(this.unhealthyUpstream, entity.getSelectorId(), upstream);
            this.removeFromMap(this.healthyUpstream, entity.getSelectorId(), upstream);
        }
    }

    private void finishHealthCheck() {
        this.checkStarted.set(false);
    }

    public void triggerAddOne(String selectorId, Upstream upstream) {
        this.putToMap(this.healthyUpstream, selectorId, upstream);
    }

    public void triggerRemoveOne(String selectorId, Upstream upstream) {
        this.removeFromMap(this.healthyUpstream, selectorId, upstream);
        this.removeFromMap(this.unhealthyUpstream, selectorId, upstream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToMap(Map<String, List<Upstream>> map, String selectorId, Upstream upstream) {
        Object object = this.lock;
        synchronized (object) {
            List list = (List)MapUtils.computeIfAbsent(map, (Object)selectorId, k -> Lists.newArrayList());
            if (!list.contains(upstream)) {
                list.add(upstream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(Map<String, List<Upstream>> map, String selectorId, Upstream upstream) {
        Object object = this.lock;
        synchronized (object) {
            List<Upstream> list = map.get(selectorId);
            if (CollectionUtils.isNotEmpty(list)) {
                list.remove(upstream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerRemoveAll(String selectorId) {
        Object object = this.lock;
        synchronized (object) {
            this.healthyUpstream.remove(selectorId);
            this.unhealthyUpstream.remove(selectorId);
        }
    }

    public void print() {
        this.printHealthyUpstream();
        this.printUnhealthyUpstream();
    }

    private void printHealthyUpstream() {
        this.healthyUpstream.forEach((k, v) -> {
            if (Objects.nonNull(v)) {
                List list = v.stream().map(Upstream::getUrl).collect(Collectors.toList());
                LOG.info("[Health Check] currently healthy upstream: {}", (Object)GsonUtils.getInstance().toJson(list));
            }
        });
    }

    private void printUnhealthyUpstream() {
        this.unhealthyUpstream.forEach((k, v) -> {
            if (Objects.nonNull(v)) {
                List list = v.stream().map(Upstream::getUrl).collect(Collectors.toList());
                LOG.info("[Health Check] currently unhealthy upstream: {}", (Object)GsonUtils.getInstance().toJson(list));
            }
        });
    }

    public Map<String, List<Upstream>> getHealthyUpstream() {
        return this.healthyUpstream;
    }

    public Map<String, List<Upstream>> getUnhealthyUpstream() {
        return this.unhealthyUpstream;
    }
}

