/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.basic.auth;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.basic.auth.handle.BasicAuthPluginDataHandler;
import org.apache.shenyu.plugin.basic.auth.rule.BasicAuthRuleHandle;
import org.apache.shenyu.plugin.basic.auth.strategy.BasicAuthAuthenticationStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class BasicAuthPlugin
extends AbstractShenyuPlugin {
    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        String authorization = StringUtils.defaultString((String)exchange.getRequest().getHeaders().getFirst("Authorization"), (String)exchange.getRequest().getURI().getUserInfo());
        BasicAuthRuleHandle basicAuthRuleHandle = (BasicAuthRuleHandle)BasicAuthPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        BasicAuthAuthenticationStrategy authenticationStrategy = Optional.ofNullable(basicAuthRuleHandle).map(BasicAuthRuleHandle::getBasicAuthAuthenticationStrategy).orElse(null);
        if (authenticationStrategy != null && authenticationStrategy.authenticate(basicAuthRuleHandle, authorization)) {
            return chain.execute(exchange);
        }
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.ERROR_TOKEN));
    }

    public String named() {
        return PluginEnum.BASIC_AUTH.getName();
    }

    public int getOrder() {
        return PluginEnum.BASIC_AUTH.getCode();
    }
}

