/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.basic.auth.handle;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.basic.auth.config.BasicAuthConfig;
import org.apache.shenyu.plugin.basic.auth.rule.BasicAuthRuleHandle;

public class BasicAuthPluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, BasicAuthRuleHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerPlugin(PluginData pluginData) {
        Map configMap = GsonUtils.getInstance().toObjectMap(pluginData.getConfig(), String.class);
        String defaultHandleJson = Optional.ofNullable(configMap.get("defaultHandleJson")).orElse("");
        BasicAuthConfig basicAuthConfig = new BasicAuthConfig();
        basicAuthConfig.setDefaultHandleJson(defaultHandleJson);
        Singleton.INST.single(BasicAuthConfig.class, (Object)basicAuthConfig);
    }

    public void removeRule(RuleData ruleData) {
        CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData));
    }

    public void handlerRule(RuleData ruleData) {
        BasicAuthConfig basicAuthConfig = (BasicAuthConfig)Singleton.INST.get(BasicAuthConfig.class);
        Optional.ofNullable(ruleData.getHandle()).ifPresent(ruleHandle -> {
            BasicAuthRuleHandle basicAuthRuleHandle = BasicAuthRuleHandle.newInstance(StringUtils.defaultString((String)ruleHandle, (String)basicAuthConfig.getDefaultHandleJson()));
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)basicAuthRuleHandle);
        });
    }

    public String pluginNamed() {
        return PluginEnum.BASIC_AUTH.getName();
    }
}

