/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.divide;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.DivideUpstream;
import org.apache.shenyu.common.dto.convert.rule.impl.DivideRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.divide.balance.utils.LoadBalanceUtils;
import org.apache.shenyu.plugin.divide.cache.UpstreamCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class DividePlugin
extends AbstractShenyuPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DividePlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        Object error;
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        DivideRuleHandle ruleHandle = (DivideRuleHandle)UpstreamCacheManager.getInstance().obtainHandle(CacheKeyUtils.INST.getKey(rule));
        long headerSize = 0L;
        for (List multiHeader : exchange.getRequest().getHeaders().values()) {
            for (String value : multiHeader) {
                headerSize += (long)value.getBytes(StandardCharsets.UTF_8).length;
            }
        }
        if (headerSize > ruleHandle.getHeaderMaxSize()) {
            log.error("request header is too large");
            error = ShenyuResultWrap.error((int)ShenyuResultEnum.REQUEST_HEADER_TOO_LARGE.getCode(), (String)ShenyuResultEnum.REQUEST_HEADER_TOO_LARGE.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        if (exchange.getRequest().getHeaders().getContentLength() > ruleHandle.getRequestMaxSize()) {
            log.error("request entity is too large");
            error = ShenyuResultWrap.error((int)ShenyuResultEnum.REQUEST_ENTITY_TOO_LARGE.getCode(), (String)ShenyuResultEnum.REQUEST_ENTITY_TOO_LARGE.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        List<DivideUpstream> upstreamList = UpstreamCacheManager.getInstance().findUpstreamListBySelectorId(selector.getId());
        if (CollectionUtils.isEmpty(upstreamList)) {
            log.error("divide upstream configuration error\uff1a {}", (Object)rule);
            Object error2 = ShenyuResultWrap.error((int)ShenyuResultEnum.CANNOT_FIND_URL.getCode(), (String)ShenyuResultEnum.CANNOT_FIND_URL.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error2);
        }
        String ip = Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress();
        DivideUpstream divideUpstream = LoadBalanceUtils.selector(upstreamList, ruleHandle.getLoadBalance(), ip);
        if (Objects.isNull(divideUpstream)) {
            log.error("divide has no upstream");
            Object error3 = ShenyuResultWrap.error((int)ShenyuResultEnum.CANNOT_FIND_URL.getCode(), (String)ShenyuResultEnum.CANNOT_FIND_URL.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error3);
        }
        String domain = this.buildDomain(divideUpstream);
        String realURL = this.buildRealURL(domain, shenyuContext, exchange);
        exchange.getAttributes().put("httpUrl", realURL);
        exchange.getAttributes().put("httpTimeOut", ruleHandle.getTimeout());
        exchange.getAttributes().put("httpRetry", ruleHandle.getRetry());
        return chain.execute(exchange);
    }

    public String named() {
        return PluginEnum.DIVIDE.getName();
    }

    public Boolean skip(ServerWebExchange exchange) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        return !Objects.equals(Objects.requireNonNull(shenyuContext).getRpcType(), RpcTypeEnum.HTTP.getName());
    }

    public int getOrder() {
        return PluginEnum.DIVIDE.getCode();
    }

    protected Mono<Void> handleSelectorIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noSelectorResult((String)pluginName, (ServerWebExchange)exchange);
    }

    protected Mono<Void> handleRuleIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noRuleResult((String)pluginName, (ServerWebExchange)exchange);
    }

    private String buildDomain(DivideUpstream divideUpstream) {
        String protocol = divideUpstream.getProtocol();
        if (StringUtils.isBlank((CharSequence)protocol)) {
            protocol = "http://";
        }
        return protocol + divideUpstream.getUpstreamUrl().trim();
    }

    private String buildRealURL(String domain, ShenyuContext shenyuContext, ServerWebExchange exchange) {
        String path = domain;
        String rewriteURI = (String)exchange.getAttributes().get("rewrite_uri");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rewriteURI})) {
            path = path + rewriteURI;
        } else {
            String realUrl = shenyuContext.getRealUrl();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{realUrl})) {
                path = path + realUrl;
            }
        }
        String query = exchange.getRequest().getURI().getQuery();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{query})) {
            return path + "?" + query;
        }
        return path;
    }
}

