/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.divide.handler;

import java.util.Optional;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.DivideRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.divide.cache.UpstreamCacheManager;

public class DividePluginDataHandler
implements PluginDataHandler {
    public void handlerSelector(SelectorData selectorData) {
        UpstreamCacheManager.getInstance().submit(selectorData);
    }

    public void removeSelector(SelectorData selectorData) {
        UpstreamCacheManager.getInstance().removeByKey(selectorData.getId());
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            DivideRuleHandle divideRuleHandle = (DivideRuleHandle)GsonUtils.getInstance().fromJson(s, DivideRuleHandle.class);
            UpstreamCacheManager.getInstance().cachedHandle(CacheKeyUtils.INST.getKey(ruleData), divideRuleHandle);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> UpstreamCacheManager.getInstance().removeHandle(CacheKeyUtils.INST.getKey(ruleData)));
    }

    public String pluginNamed() {
        return PluginEnum.DIVIDE.getName();
    }
}

