/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.param.mapping.strategy;

import com.google.gson.reflect.TypeToken;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.convert.rule.impl.ParamMappingRuleHandle;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.support.BodyInserterContext;
import org.apache.shenyu.plugin.base.support.CachedBodyOutputMessage;
import org.apache.shenyu.plugin.param.mapping.strategy.Operator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FormDataOperator
implements Operator {
    private static final Logger LOG = LoggerFactory.getLogger(FormDataOperator.class);

    @Override
    public Mono<Void> apply(ServerWebExchange exchange, ShenyuPluginChain shenyuPluginChain, ParamMappingRuleHandle paramMappingRuleHandle) {
        return exchange.getFormData().switchIfEmpty(Mono.defer(() -> Mono.just((Object)new LinkedMultiValueMap()))).flatMap(multiValueMap -> {
            if (Objects.isNull(multiValueMap) || multiValueMap.isEmpty()) {
                return shenyuPluginChain.execute(exchange);
            }
            String original = GsonUtils.getInstance().toJson(multiValueMap);
            LOG.info("get from data success data:{}", (Object)original);
            String modify = this.operation(original, paramMappingRuleHandle);
            if (!StringUtils.hasLength((String)modify)) {
                return shenyuPluginChain.execute(exchange);
            }
            HttpHeaders headers = exchange.getRequest().getHeaders();
            HttpHeaders httpHeaders = new HttpHeaders();
            Charset charset = Objects.requireNonNull(headers.getContentType()).getCharset();
            charset = charset == null ? StandardCharsets.UTF_8 : charset;
            LinkedMultiValueMap<String, String> modifyMap = this.toLinkedMultiValueMap(modify);
            List<String> list = this.prepareParams(modifyMap, charset.name());
            String content = String.join((CharSequence)"&", list);
            byte[] bodyBytes = content.getBytes(charset);
            int contentLength = bodyBytes.length;
            BodyInserter bodyInserter = BodyInserters.fromValue(modifyMap);
            httpHeaders.putAll((Map)headers);
            httpHeaders.remove((Object)"Content-Length");
            httpHeaders.setContentLength((long)contentLength);
            CachedBodyOutputMessage cachedBodyOutputMessage = new CachedBodyOutputMessage(exchange, httpHeaders);
            return bodyInserter.insert((ReactiveHttpOutputMessage)cachedBodyOutputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> shenyuPluginChain.execute(exchange.mutate().request((ServerHttpRequest)new ModifyServerHttpRequestDecorator(httpHeaders, exchange.getRequest(), cachedBodyOutputMessage)).build()))).onErrorResume(throwable -> this.release(cachedBodyOutputMessage, (Throwable)throwable));
        });
    }

    @Override
    public void operation(DocumentContext context, ParamMappingRuleHandle paramMappingRuleHandle) {
        if (!CollectionUtils.isEmpty((Collection)paramMappingRuleHandle.getAddParameterKeys())) {
            paramMappingRuleHandle.getAddParameterKeys().forEach(info -> context.put(info.getPath(), info.getKey(), Collections.singletonList(info.getValue()), new Predicate[0]));
        }
    }

    private List<String> prepareParams(LinkedMultiValueMap<String, String> modifyMap, String charset) {
        ArrayList<String> paramList = new ArrayList<String>();
        modifyMap.forEach((K, V) -> V.forEach(value -> {
            try {
                paramList.add(String.join((CharSequence)"=", K, URLEncoder.encode(value, charset)));
            }
            catch (UnsupportedEncodingException e) {
                throw new ShenyuException((Throwable)e);
            }
        }));
        return paramList;
    }

    public LinkedMultiValueMap<String, String> toLinkedMultiValueMap(String json) {
        return (LinkedMultiValueMap)GsonUtils.getGson().fromJson(json, new TypeToken<LinkedMultiValueMap<String, String>>(){}.getType());
    }

    static class ModifyServerHttpRequestDecorator
    extends ServerHttpRequestDecorator {
        private final HttpHeaders headers;
        private final CachedBodyOutputMessage cachedBodyOutputMessage;

        ModifyServerHttpRequestDecorator(HttpHeaders headers, ServerHttpRequest delegate, CachedBodyOutputMessage cachedBodyOutputMessage) {
            super(delegate);
            this.headers = headers;
            this.cachedBodyOutputMessage = cachedBodyOutputMessage;
        }

        public HttpHeaders getHeaders() {
            long contentLength = this.headers.getContentLength();
            if (contentLength == 0L) {
                this.headers.set("Transfer-Encoding", "chunked");
            }
            return this.headers;
        }

        public Flux<DataBuffer> getBody() {
            return this.cachedBodyOutputMessage.getBody();
        }
    }
}

