/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.springcloud.loadbalance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.convert.selector.SpringCloudSelectorHandle;
import org.apache.shenyu.loadbalancer.cache.UpstreamCacheManager;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.factory.LoadBalancerFactory;
import org.apache.shenyu.plugin.springcloud.handler.SpringCloudPluginDataHandler;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public final class ShenyuSpringCloudServiceChooser {
    private final DiscoveryClient discoveryClient;

    public ShenyuSpringCloudServiceChooser(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    public Upstream choose(String serviceId, String selectorId, String ip, String loadbalancer) {
        List<ServiceInstance> available = this.getServiceInstance(serviceId);
        if (CollectionUtils.isEmpty(available)) {
            return null;
        }
        SpringCloudSelectorHandle springCloudSelectorHandle = (SpringCloudSelectorHandle)SpringCloudPluginDataHandler.SELECTOR_CACHED.get().obtainHandle((Object)selectorId);
        if (!springCloudSelectorHandle.getGray()) {
            return this.doSelect(serviceId, ip, loadbalancer);
        }
        List divideUpstreams = UpstreamCacheManager.getInstance().findUpstreamListBySelectorId(selectorId);
        if (CollectionUtils.isEmpty((Collection)divideUpstreams)) {
            return this.doSelect(serviceId, ip, loadbalancer);
        }
        ArrayList<Upstream> choose = new ArrayList<Upstream>(available.size());
        for (ServiceInstance serviceInstance : available) {
            divideUpstreams.stream().filter(Upstream::isStatus).filter(upstream -> Objects.equals(upstream.getUrl(), serviceInstance.getUri().getRawAuthority())).findFirst().ifPresent(choose::add);
        }
        if (CollectionUtils.isEmpty(choose)) {
            return this.doSelect(serviceId, ip, loadbalancer);
        }
        return this.doSelect(choose, loadbalancer, ip);
    }

    private Upstream doSelect(String serviceId, String ip, String loadbalancer) {
        List<Upstream> choose = this.buildUpstream(serviceId);
        return this.doSelect(choose, loadbalancer, ip);
    }

    private Upstream doSelect(List<Upstream> upstreamList, String loadbalancer, String ip) {
        return LoadBalancerFactory.selector(upstreamList, (String)loadbalancer, (String)ip);
    }

    private List<ServiceInstance> getServiceInstance(String serviceId) {
        List serviceNames = this.discoveryClient.getServices().stream().map(String::toUpperCase).collect(Collectors.toList());
        if (!serviceNames.contains(serviceId.toUpperCase())) {
            return Collections.emptyList();
        }
        return this.discoveryClient.getInstances(serviceId);
    }

    private List<Upstream> buildUpstream(String serviceId) {
        List<ServiceInstance> serviceInstanceList = this.getServiceInstance(serviceId);
        if (serviceInstanceList.isEmpty()) {
            return Collections.emptyList();
        }
        return serviceInstanceList.stream().map(serviceInstance -> ShenyuSpringCloudServiceChooser.buildDefaultSpringCloudUpstream(serviceInstance.getUri().getRawAuthority(), serviceInstance.getScheme() + "://")).distinct().collect(Collectors.toList());
    }

    private static Upstream buildDefaultSpringCloudUpstream(String upstreamUrl, String protocol) {
        return Upstream.builder().url(upstreamUrl).protocol(protocol).weight(50).warmup(10).timestamp(0L).build();
    }
}

