/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice;

import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import org.apache.shiro.guice.DestroyableInjectionListener;
import org.apache.shiro.guice.InitializableInjectionListener;

class LifecycleTypeListener
implements TypeListener {
    public static final Matcher<TypeLiteral> MATCHER = InitializableInjectionListener.MATCHER.or(DestroyableInjectionListener.MATCHER);
    private DestroyableInjectionListener.DestroyableRegistry registry;

    public LifecycleTypeListener(DestroyableInjectionListener.DestroyableRegistry registry) {
        this.registry = registry;
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        if (InitializableInjectionListener.MATCHER.matches(type)) {
            encounter.register(this.castListener(new InitializableInjectionListener()));
        }
        if (DestroyableInjectionListener.MATCHER.matches(type)) {
            encounter.register(this.castListener(new DestroyableInjectionListener(this.registry)));
        }
    }

    private <I> InjectionListener<? super I> castListener(InjectionListener<?> listener) {
        return listener;
    }
}

