/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.config.web.autoconfigure;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.List;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.spring.web.config.AbstractShiroWebFilterConfiguration;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(name={"shiro.web.enabled"}, matchIfMissing=true)
public class ShiroWebFilterConfiguration
extends AbstractShiroWebFilterConfiguration {
    public static final String REGISTRATION_BEAN_NAME = "filterShiroFilterRegistrationBean";
    public static final String FILTER_NAME = "shiroFilter";

    @Bean
    @ConditionalOnMissingBean
    protected ShiroFilterFactoryBean shiroFilterFactoryBean() {
        return super.shiroFilterFactoryBean();
    }

    @Bean(name={"filterShiroFilterRegistrationBean"})
    @ConditionalOnMissingBean(name={"filterShiroFilterRegistrationBean"})
    protected FilterRegistrationBean<AbstractShiroFilter> filterShiroFilterRegistrationBean() throws Exception {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.ERROR});
        filterRegistrationBean.setFilter((Filter)((AbstractShiroFilter)this.shiroFilterFactoryBean().getObject()));
        filterRegistrationBean.setName(FILTER_NAME);
        filterRegistrationBean.setOrder(1);
        return filterRegistrationBean;
    }

    @Bean(name={"globalFilters"})
    @ConditionalOnMissingBean
    protected List<String> globalFilters() {
        return super.globalFilters();
    }
}

