/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;

public abstract class CollectionAdminRequest<Q extends CollectionAdminRequest<Q>>
extends SolrRequest<CollectionAdminResponse> {
    protected CollectionParams.CollectionAction action = null;
    private static String PROPERTY_PREFIX = "property.";

    protected CollectionAdminRequest setAction(CollectionParams.CollectionAction action) {
        this.action = action;
        return this;
    }

    public CollectionAdminRequest() {
        super(SolrRequest.METHOD.GET, "/admin/collections");
    }

    public CollectionAdminRequest(String path) {
        super(SolrRequest.METHOD.GET, path);
    }

    protected abstract Q getThis();

    @Override
    public SolrParams getParams() {
        if (this.action == null) {
            throw new RuntimeException("no action specified!");
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", this.action.toString());
        return params;
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        return null;
    }

    @Override
    protected CollectionAdminResponse createResponse(SolrClient client) {
        return new CollectionAdminResponse();
    }

    protected void addProperties(ModifiableSolrParams params, Properties props) {
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            String key = (String)prop.getKey();
            String value = (String)prop.getValue();
            params.set(PROPERTY_PREFIX + key, value);
        }
    }

    public static class BalanceShardUnique
    extends AsyncCollectionAdminRequest<BalanceShardUnique> {
        protected String collection;
        protected String propertyName;
        protected Boolean onlyActiveNodes;
        protected Boolean shardUnique;

        public BalanceShardUnique() {
            this.action = CollectionParams.CollectionAction.BALANCESHARDUNIQUE;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public BalanceShardUnique setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public Boolean getOnlyActiveNodes() {
            return this.onlyActiveNodes;
        }

        public BalanceShardUnique setOnlyActiveNodes(Boolean onlyActiveNodes) {
            this.onlyActiveNodes = onlyActiveNodes;
            return this;
        }

        public Boolean getShardUnique() {
            return this.shardUnique;
        }

        public BalanceShardUnique setShardUnique(Boolean shardUnique) {
            this.shardUnique = shardUnique;
            return this;
        }

        public BalanceShardUnique setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public String getCollection() {
            return this.collection;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("collection", this.collection);
            params.set("property", this.propertyName);
            if (this.onlyActiveNodes != null) {
                params.set("onlyactivenodes", this.onlyActiveNodes);
            }
            if (this.shardUnique != null) {
                params.set("shardUnique", this.shardUnique);
            }
            return params;
        }

        @Override
        protected BalanceShardUnique getThis() {
            return this;
        }
    }

    public static class MigrateClusterState
    extends CollectionShardAsyncAdminRequest<MigrateClusterState> {
        public MigrateClusterState() {
            this.action = CollectionParams.CollectionAction.MIGRATESTATEFORMAT;
        }

        @Override
        public MigrateClusterState setShardName(String shard) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getShardName() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected MigrateClusterState getThis() {
            return this;
        }
    }

    public static class DeleteReplicaProp
    extends CollectionShardAsyncAdminRequest<DeleteReplicaProp> {
        private String replica;
        private String propertyName;

        public DeleteReplicaProp() {
            this.action = CollectionParams.CollectionAction.DELETEREPLICAPROP;
        }

        public String getReplica() {
            return this.replica;
        }

        public DeleteReplicaProp setReplica(String replica) {
            this.replica = replica;
            return this;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public DeleteReplicaProp setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("replica", this.replica);
            params.set("property", this.propertyName);
            return params;
        }

        @Override
        protected DeleteReplicaProp getThis() {
            return this;
        }
    }

    public static class AddReplicaProp
    extends CollectionShardAsyncAdminRequest<AddReplicaProp> {
        private String replica;
        private String propertyName;
        private String propertyValue;
        private Boolean shardUnique;

        public AddReplicaProp() {
            this.action = CollectionParams.CollectionAction.ADDREPLICAPROP;
        }

        public String getReplica() {
            return this.replica;
        }

        public AddReplicaProp setReplica(String replica) {
            this.replica = replica;
            return this;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public AddReplicaProp setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public AddReplicaProp setPropertyValue(String propertyValue) {
            this.propertyValue = propertyValue;
            return this;
        }

        public Boolean getShardUnique() {
            return this.shardUnique;
        }

        public AddReplicaProp setShardUnique(Boolean shardUnique) {
            this.shardUnique = shardUnique;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("replica", this.replica);
            params.set("property", this.propertyName);
            params.set("property.value", this.propertyValue);
            if (this.shardUnique != null) {
                params.set("shardUnique", this.shardUnique);
            }
            return params;
        }

        @Override
        protected AddReplicaProp getThis() {
            return this;
        }
    }

    public static class List
    extends CollectionAdminRequest<List> {
        public List() {
            this.action = CollectionParams.CollectionAction.LIST;
        }

        @Override
        protected List getThis() {
            return this;
        }
    }

    public static class ClusterStatus
    extends CollectionAdminRequest<ClusterStatus> {
        protected String shardName = null;
        protected String collection = null;
        protected String routeKey = null;

        public ClusterStatus() {
            this.action = CollectionParams.CollectionAction.CLUSTERSTATUS;
        }

        public ClusterStatus setCollectionName(String collectionName) {
            this.collection = collectionName;
            return this;
        }

        public String getCollectionName() {
            return this.collection;
        }

        public ClusterStatus setShardName(String shard) {
            this.shardName = shard;
            return this;
        }

        public String getShardName() {
            return this.shardName;
        }

        public String getRouteKey() {
            return this.routeKey;
        }

        public ClusterStatus setRouteKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            if (this.collection != null) {
                params.set("collection", this.collection);
            }
            if (this.shardName != null) {
                params.set("shard", this.shardName);
            }
            if (this.routeKey != null) {
                params.set("_route_", this.routeKey);
            }
            return params;
        }

        @Override
        protected ClusterStatus getThis() {
            return this;
        }
    }

    public static class OverseerStatus
    extends AsyncCollectionAdminRequest<OverseerStatus> {
        public OverseerStatus() {
            this.action = CollectionParams.CollectionAction.OVERSEERSTATUS;
        }

        @Override
        protected OverseerStatus getThis() {
            return this;
        }
    }

    public static class RemoveRole
    extends CollectionAdminRoleRequest<RemoveRole> {
        public RemoveRole() {
            this.action = CollectionParams.CollectionAction.REMOVEROLE;
        }

        @Override
        protected RemoveRole getThis() {
            return this;
        }
    }

    public static class AddRole
    extends CollectionAdminRoleRequest<AddRole> {
        public AddRole() {
            this.action = CollectionParams.CollectionAction.ADDROLE;
        }

        @Override
        protected AddRole getThis() {
            return this;
        }
    }

    public static class Migrate
    extends AsyncCollectionAdminRequest<Migrate> {
        private String collection;
        private String targetCollection;
        private String splitKey;
        private Integer forwardTimeout;
        private Properties properties;

        public Migrate() {
            this.action = CollectionParams.CollectionAction.MIGRATE;
        }

        public Migrate setCollectionName(String collection) {
            this.collection = collection;
            return this;
        }

        public String getCollectionName() {
            return this.collection;
        }

        public Migrate setTargetCollection(String targetCollection) {
            this.targetCollection = targetCollection;
            return this;
        }

        public String getTargetCollection() {
            return this.targetCollection;
        }

        public Migrate setSplitKey(String splitKey) {
            this.splitKey = splitKey;
            return this;
        }

        public String getSplitKey() {
            return this.splitKey;
        }

        public Migrate setForwardTimeout(int forwardTimeout) {
            this.forwardTimeout = forwardTimeout;
            return this;
        }

        public Integer getForwardTimeout() {
            return this.forwardTimeout;
        }

        public Migrate setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("collection", this.collection);
            params.set("target.collection", this.targetCollection);
            params.set("split.key", this.splitKey);
            if (this.forwardTimeout != null) {
                params.set("forward.timeout", this.forwardTimeout);
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            return params;
        }

        @Override
        protected Migrate getThis() {
            return this;
        }
    }

    public static class ClusterProp
    extends CollectionAdminRequest<ClusterProp> {
        private String propertyName;
        private String propertyValue;

        public ClusterProp() {
            this.action = CollectionParams.CollectionAction.CLUSTERPROP;
        }

        public ClusterProp setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public ClusterProp setPropertyValue(String propertyValue) {
            this.propertyValue = propertyValue;
            return this;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.add("name", this.propertyName);
            params.add("val", this.propertyValue);
            return params;
        }

        @Override
        protected ClusterProp getThis() {
            return this;
        }
    }

    public static class DeleteReplica
    extends CollectionShardAsyncAdminRequest<DeleteReplica> {
        protected String replica;
        protected Boolean onlyIfDown;

        public DeleteReplica() {
            this.action = CollectionParams.CollectionAction.DELETEREPLICA;
        }

        public DeleteReplica setReplica(String replica) {
            this.replica = replica;
            return this;
        }

        public String getReplica() {
            return this.replica;
        }

        public DeleteReplica setOnlyIfDown(boolean onlyIfDown) {
            this.onlyIfDown = onlyIfDown;
            return this;
        }

        public Boolean getOnlyIfDown() {
            return this.onlyIfDown;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("replica", this.replica);
            if (this.onlyIfDown != null) {
                params.set("onlyIfDown", this.onlyIfDown);
            }
            return params;
        }

        @Override
        protected DeleteReplica getThis() {
            return this;
        }
    }

    public static class AddReplica
    extends CollectionShardAsyncAdminRequest<AddReplica> {
        protected String node;
        protected String routeKey;
        protected String instanceDir;
        protected String dataDir;
        protected Properties properties;

        public AddReplica() {
            this.action = CollectionParams.CollectionAction.ADDREPLICA;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public AddReplica setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public String getNode() {
            return this.node;
        }

        public AddReplica setNode(String node) {
            this.node = node;
            return this;
        }

        public String getRouteKey() {
            return this.routeKey;
        }

        public AddReplica setRouteKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        public String getInstanceDir() {
            return this.instanceDir;
        }

        public AddReplica setInstanceDir(String instanceDir) {
            this.instanceDir = instanceDir;
            return this;
        }

        public String getDataDir() {
            return this.dataDir;
        }

        public AddReplica setDataDir(String dataDir) {
            this.dataDir = dataDir;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            if (this.shardName == null || this.shardName.isEmpty()) {
                params.remove("shard");
                if (this.routeKey == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either shard or routeKey must be provided");
                }
                params.add("_route_", this.routeKey);
            }
            if (this.node != null) {
                params.add("node", this.node);
            }
            if (this.instanceDir != null) {
                params.add("instanceDir", this.instanceDir);
            }
            if (this.dataDir != null) {
                params.add("dataDir", this.dataDir);
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            return params;
        }

        @Override
        protected AddReplica getThis() {
            return this;
        }
    }

    public static class DeleteAlias
    extends AsyncCollectionAdminRequest<DeleteAlias> {
        protected String aliasName;

        public DeleteAlias() {
            this.action = CollectionParams.CollectionAction.DELETEALIAS;
        }

        public DeleteAlias setAliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("name", this.aliasName);
            return params;
        }

        @Override
        protected DeleteAlias getThis() {
            return this;
        }
    }

    public static class CreateAlias
    extends AsyncCollectionAdminRequest<CreateAlias> {
        protected String aliasName;
        protected String aliasedCollections;

        public CreateAlias() {
            this.action = CollectionParams.CollectionAction.CREATEALIAS;
        }

        public CreateAlias setAliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        public CreateAlias setAliasedCollections(String alias) {
            this.aliasedCollections = alias;
            return this;
        }

        public String getAliasedCollections() {
            return this.aliasedCollections;
        }

        @Deprecated
        public void setCollectionName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("name", this.aliasName);
            params.set("collections", this.aliasedCollections);
            return params;
        }

        @Override
        protected CreateAlias getThis() {
            return this;
        }
    }

    public static class DeleteStatus
    extends CollectionAdminRequest<DeleteStatus> {
        protected String requestId = null;
        protected Boolean flush = null;

        public DeleteStatus() {
            this.action = CollectionParams.CollectionAction.DELETESTATUS;
        }

        public DeleteStatus setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public DeleteStatus setFlush(Boolean flush) {
            this.flush = flush;
            return this;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Boolean getFlush() {
            return this.flush;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            if (this.requestId != null) {
                params.set("requestid", this.requestId);
            }
            if (this.flush != null) {
                params.set("flush", this.flush);
            }
            return params;
        }

        @Override
        protected DeleteStatus getThis() {
            return this;
        }
    }

    public static class RequestStatus
    extends CollectionAdminRequest<RequestStatus> {
        protected String requestId = null;

        public RequestStatus() {
            this.action = CollectionParams.CollectionAction.REQUESTSTATUS;
        }

        public RequestStatus setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public String getRequestId() {
            return this.requestId;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("requestid", this.requestId);
            return params;
        }

        @Override
        protected RequestStatus getThis() {
            return this;
        }
    }

    public static class ForceLeader
    extends CollectionShardAdminRequest<ForceLeader> {
        public ForceLeader() {
            this.action = CollectionParams.CollectionAction.FORCELEADER;
        }

        @Override
        protected ForceLeader getThis() {
            return this;
        }
    }

    public static class DeleteShard
    extends CollectionShardAsyncAdminRequest<DeleteShard> {
        public DeleteShard() {
            this.action = CollectionParams.CollectionAction.DELETESHARD;
        }

        @Override
        protected DeleteShard getThis() {
            return this;
        }
    }

    public static class SplitShard
    extends CollectionShardAsyncAdminRequest<SplitShard> {
        protected String ranges;
        protected String splitKey;
        private Properties properties;

        public SplitShard() {
            this.action = CollectionParams.CollectionAction.SPLITSHARD;
        }

        public SplitShard setRanges(String ranges) {
            this.ranges = ranges;
            return this;
        }

        public String getRanges() {
            return this.ranges;
        }

        public SplitShard setSplitKey(String splitKey) {
            this.splitKey = splitKey;
            return this;
        }

        public String getSplitKey() {
            return this.splitKey;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public SplitShard setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("ranges", this.ranges);
            if (this.splitKey != null) {
                params.set("split.key", this.splitKey);
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            return params;
        }

        @Override
        protected SplitShard getThis() {
            return this;
        }
    }

    public static class CreateShard
    extends CollectionShardAsyncAdminRequest<CreateShard> {
        protected String nodeSet;
        protected Properties properties;

        public CreateShard setNodeSet(String nodeSet) {
            this.nodeSet = nodeSet;
            return this;
        }

        public String getNodeSet() {
            return this.nodeSet;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public CreateShard setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public CreateShard() {
            this.action = CollectionParams.CollectionAction.CREATESHARD;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            if (this.nodeSet != null) {
                params.set("createNodeSet", this.nodeSet);
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            return params;
        }

        @Override
        protected CreateShard getThis() {
            return this;
        }
    }

    public static class Delete
    extends CollectionSpecificAsyncAdminRequest<Delete> {
        public Delete() {
            this.action = CollectionParams.CollectionAction.DELETE;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            return params;
        }

        @Override
        protected Delete getThis() {
            return this;
        }
    }

    public static class Reload
    extends CollectionSpecificAsyncAdminRequest<Reload> {
        public Reload() {
            this.action = CollectionParams.CollectionAction.RELOAD;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            return params;
        }

        @Override
        protected Reload getThis() {
            return this;
        }
    }

    public static class Create
    extends CollectionSpecificAsyncAdminRequest<Create> {
        protected String configName = null;
        protected String createNodeSet = null;
        protected String routerName;
        protected String shards;
        protected String routerField;
        protected Integer numShards;
        protected Integer maxShardsPerNode;
        protected Integer replicationFactor;
        private Properties properties;
        protected Boolean autoAddReplicas;
        protected Integer stateFormat;
        private String[] rule;
        private String[] snitch;

        public Create() {
            this.action = CollectionParams.CollectionAction.CREATE;
        }

        public Create setConfigName(String config) {
            this.configName = config;
            return this;
        }

        public Create setCreateNodeSet(String nodeSet) {
            this.createNodeSet = nodeSet;
            return this;
        }

        public Create setRouterName(String routerName) {
            this.routerName = routerName;
            return this;
        }

        public Create setShards(String shards) {
            this.shards = shards;
            return this;
        }

        public Create setRouterField(String routerField) {
            this.routerField = routerField;
            return this;
        }

        public Create setNumShards(Integer numShards) {
            this.numShards = numShards;
            return this;
        }

        public Create setMaxShardsPerNode(Integer numShards) {
            this.maxShardsPerNode = numShards;
            return this;
        }

        public Create setAutoAddReplicas(boolean autoAddReplicas) {
            this.autoAddReplicas = autoAddReplicas;
            return this;
        }

        public Create setReplicationFactor(Integer repl) {
            this.replicationFactor = repl;
            return this;
        }

        public Create setStateFormat(Integer stateFormat) {
            this.stateFormat = stateFormat;
            return this;
        }

        public Create setRule(String ... s) {
            this.rule = s;
            return this;
        }

        public Create setSnitch(String ... s) {
            this.snitch = s;
            return this;
        }

        public String getConfigName() {
            return this.configName;
        }

        public String getCreateNodeSet() {
            return this.createNodeSet;
        }

        public String getRouterName() {
            return this.routerName;
        }

        public String getShards() {
            return this.shards;
        }

        public Integer getNumShards() {
            return this.numShards;
        }

        public Integer getMaxShardsPerNode() {
            return this.maxShardsPerNode;
        }

        public Integer getReplicationFactor() {
            return this.replicationFactor;
        }

        public Boolean getAutoAddReplicas() {
            return this.autoAddReplicas;
        }

        public Integer getStateFormat() {
            return this.stateFormat;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public Create setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("collection.configName", this.configName);
            params.set("createNodeSet", this.createNodeSet);
            if (this.numShards != null) {
                params.set("numShards", this.numShards);
            }
            if (this.maxShardsPerNode != null) {
                params.set("maxShardsPerNode", this.maxShardsPerNode);
            }
            params.set("router.name", this.routerName);
            params.set("shards", this.shards);
            if (this.routerField != null) {
                params.set("router.field", this.routerField);
            }
            if (this.replicationFactor != null) {
                params.set("replicationFactor", this.replicationFactor);
            }
            if (this.autoAddReplicas != null) {
                params.set("autoAddReplicas", this.autoAddReplicas);
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            if (this.stateFormat != null) {
                params.set("stateFormat", this.stateFormat);
            }
            if (this.rule != null) {
                params.set("rule", this.rule);
            }
            if (this.snitch != null) {
                params.set("snitch", this.snitch);
            }
            return params;
        }

        @Override
        protected Create getThis() {
            return this;
        }
    }

    protected static abstract class CollectionAdminRoleRequest<T extends CollectionAdminRequest<T>>
    extends AsyncCollectionAdminRequest<T> {
        protected String node;
        protected String role;

        protected CollectionAdminRoleRequest() {
        }

        public T setNode(String node) {
            this.node = node;
            return (T)this.getThis();
        }

        public String getNode() {
            return this.node;
        }

        public T setRole(String role) {
            this.role = role;
            return (T)this.getThis();
        }

        public String getRole() {
            return this.role;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("role", this.role);
            params.set("node", this.node);
            return params;
        }
    }

    protected static abstract class CollectionShardAsyncAdminRequest<T extends CollectionAdminRequest<T>>
    extends CollectionShardAdminRequest<T> {
        protected String asyncId = null;

        protected CollectionShardAsyncAdminRequest() {
        }

        public final T setAsyncId(String asyncId) {
            this.asyncId = asyncId;
            return (T)this.getThis();
        }

        public String getAsyncId() {
            return this.asyncId;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            if (this.asyncId != null) {
                params.set("async", this.asyncId);
            }
            return params;
        }
    }

    protected static abstract class CollectionShardAdminRequest<T extends CollectionAdminRequest<T>>
    extends CollectionAdminRequest<T> {
        protected String shardName = null;
        protected String collection = null;

        protected CollectionShardAdminRequest() {
        }

        public T setCollectionName(String collectionName) {
            this.collection = collectionName;
            return (T)this.getThis();
        }

        public String getCollectionName() {
            return this.collection;
        }

        public T setShardName(String shard) {
            this.shardName = shard;
            return (T)this.getThis();
        }

        public String getShardName() {
            return this.shardName;
        }

        @Deprecated
        public ModifiableSolrParams getCommonParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("collection", this.collection);
            params.set("shard", this.shardName);
            return params;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("collection", this.collection);
            params.set("shard", this.shardName);
            return params;
        }
    }

    protected static abstract class CollectionSpecificAsyncAdminRequest<T extends CollectionAdminRequest<T>>
    extends CollectionSpecificAdminRequest<T> {
        protected String asyncId = null;

        protected CollectionSpecificAsyncAdminRequest() {
        }

        public final T setAsyncId(String asyncId) {
            this.asyncId = asyncId;
            return (T)this.getThis();
        }

        public String getAsyncId() {
            return this.asyncId;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            if (this.asyncId != null) {
                params.set("async", this.asyncId);
            }
            return params;
        }
    }

    protected static abstract class CollectionSpecificAdminRequest<T extends CollectionAdminRequest<T>>
    extends CollectionAdminRequest<T> {
        protected String collection = null;

        protected CollectionSpecificAdminRequest() {
        }

        public final T setCollectionName(String collectionName) {
            this.collection = collectionName;
            return (T)this.getThis();
        }

        public final String getCollectionName() {
            return this.collection;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("name", this.collection);
            return params;
        }
    }

    protected static abstract class AsyncCollectionAdminRequest<T extends CollectionAdminRequest<T>>
    extends CollectionAdminRequest<T> {
        protected String asyncId = null;

        protected AsyncCollectionAdminRequest() {
        }

        public final T setAsyncId(String asyncId) {
            this.asyncId = asyncId;
            return (T)this.getThis();
        }

        public String getAsyncId() {
            return this.asyncId;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            if (this.asyncId != null) {
                params.set("async", this.asyncId);
            }
            return params;
        }
    }
}

