/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiPredicate;
import org.apache.solr.common.ConditionalMapWriter;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.Utils;

public class ReplicaInfo
implements MapWriter {
    private final String name;
    private String core;
    private String collection;
    private String shard;
    private Replica.Type type;
    private String node;
    public final boolean isLeader;
    private final Map<String, Object> variables = new HashMap<String, Object>();

    public ReplicaInfo(String coll, String shard, Replica r, Map<String, Object> vals) {
        this.name = r.getName();
        this.core = r.getCoreName();
        this.collection = coll;
        this.shard = shard;
        this.type = r.getType();
        boolean maybeLeader = r.getBool("leader", false);
        if (vals != null) {
            this.variables.putAll(vals);
            maybeLeader = "true".equals(String.valueOf(vals.getOrDefault("leader", maybeLeader)));
        }
        this.isLeader = maybeLeader;
        this.node = r.getNodeName();
    }

    public ReplicaInfo(String name, String core, String coll, String shard, Replica.Type type, String node, Map<String, Object> vals) {
        if (vals == null) {
            vals = Collections.emptyMap();
        }
        this.name = name;
        if (vals != null) {
            this.variables.putAll(vals);
        }
        this.isLeader = "true".equals(String.valueOf(vals.getOrDefault("leader", "false")));
        this.collection = coll;
        this.shard = shard;
        this.type = type;
        this.core = core;
        this.node = node;
    }

    ReplicaInfo(Map<String, Object> map) {
        this.name = map.keySet().iterator().next();
        Map details = (Map)map.get(this.name);
        details = Utils.getDeepCopy(details, 4);
        this.collection = (String)details.remove("collection");
        this.shard = (String)details.remove("shard");
        this.core = (String)details.remove("core");
        this.node = (String)details.remove("node_name");
        this.isLeader = Boolean.parseBoolean(details.getOrDefault("leader", "false"));
        details.remove("leader");
        this.type = Replica.Type.valueOf(details.getOrDefault("type", "NRT"));
        details.remove("type");
        this.variables.putAll(details);
    }

    public Object clone() {
        return new ReplicaInfo(this.name, this.core, this.collection, this.shard, this.type, this.node, this.variables);
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        BiPredicate<CharSequence, Object> p = ConditionalMapWriter.dedupeKeyPredicate(new HashSet<CharSequence>()).and(ConditionalMapWriter.NON_NULL_VAL);
        ew.put((CharSequence)this.name, ew1 -> {
            ew1.put("core", this.core, p).put("shard", this.shard, p).put("collection", this.collection, p).put("node_name", this.node, p).put("type", this.type.toString(), p);
            for (Map.Entry<String, Object> e : this.variables.entrySet()) {
                ew1.put(e.getKey(), e.getValue(), p);
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public String getCore() {
        return this.core;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getShard() {
        return this.shard;
    }

    public Replica.Type getType() {
        Replica.Type o;
        Object object = o = this.type == null ? this.variables.get("type") : this.type;
        if (o == null) {
            return Replica.Type.NRT;
        }
        if (o instanceof Replica.Type) {
            return o;
        }
        Replica.Type type = Replica.Type.get(String.valueOf((Object)o).toUpperCase(Locale.ROOT));
        return type;
    }

    public Replica.State getState() {
        if (this.variables.get("state") != null) {
            return Replica.State.getState((String)this.variables.get("state"));
        }
        this.variables.put("state", Replica.State.ACTIVE.toString());
        return Replica.State.ACTIVE;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Object getVariable(String name) {
        return this.variables.get(name);
    }

    public Object getVariable(String name, Object defValue) {
        Object o = this.variables.get(name);
        if (o != null) {
            return o;
        }
        return defValue;
    }

    public boolean getBool(String name, boolean defValue) {
        Object o = this.getVariable(name, defValue);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.parseBoolean(String.valueOf(o));
    }

    public String toString() {
        return Utils.toJSONString(this);
    }

    public String getNode() {
        return this.node;
    }
}

