/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.spark_project.dmg.pmml.Array;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.FieldName;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.HasValueSet;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.Predicate;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;
import org.spark_project.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "array"})
@XmlRootElement(name="SimpleSetPredicate", namespace="http://www.dmg.org/PMML-4_2")
public class SimpleSetPredicate
extends Predicate
implements HasExtensions,
HasValueSet {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name="booleanOperator", required=true)
    private BooleanOperator booleanOperator;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="Array", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private Array array;

    public SimpleSetPredicate() {
    }

    public SimpleSetPredicate(FieldName field, BooleanOperator booleanOperator, Array array) {
        this.field = field;
        this.booleanOperator = booleanOperator;
        this.array = array;
    }

    @Override
    public FieldName getField() {
        return this.field;
    }

    public SimpleSetPredicate setField(FieldName field) {
        this.field = field;
        return this;
    }

    public BooleanOperator getBooleanOperator() {
        return this.booleanOperator;
    }

    public SimpleSetPredicate setBooleanOperator(BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Array getArray() {
        return this.array;
    }

    @Override
    public SimpleSetPredicate setArray(Array array) {
        this.array = array;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public SimpleSetPredicate addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum BooleanOperator {
        IS_IN("isIn"),
        IS_NOT_IN("isNotIn");

        private final String value;

        private BooleanOperator(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static BooleanOperator fromValue(String v) {
            for (BooleanOperator c : BooleanOperator.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

