/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.clustering.KMeans$;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.ml.clustering.KMeansParams;
import org.apache.spark.ml.clustering.KMeansParams$class;
import org.apache.spark.ml.clustering.KMeansSummary;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0001\u0003\u00015\u0011aaS'fC:\u001c(BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dYI\u0002cA\b\u0011%5\tA!\u0003\u0002\u0012\t\tIQi\u001d;j[\u0006$xN\u001d\t\u0003'Qi\u0011AA\u0005\u0003+\t\u00111bS'fC:\u001cXj\u001c3fYB\u00111cF\u0005\u00031\t\u0011AbS'fC:\u001c\b+\u0019:b[N\u0004\"AG\u000f\u000e\u0003mQ!\u0001\b\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003=m\u0011Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW\r\u0003\u0005!\u0001\t\u0015\r\u0011\"\u0011\"\u0003\r)\u0018\u000eZ\u000b\u0002EA\u00111%\u000b\b\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&J\u0001\u0007!J,G-\u001a4\n\u0005)Z#AB*ue&twM\u0003\u0002)K!\u001aq$L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0005A2\u0011AC1o]>$\u0018\r^5p]&\u0011!g\f\u0002\u0006'&t7-Z\u0011\u0002i\u0005)\u0011GL\u001b/a!Aa\u0007\u0001B\u0001B\u0003%!%\u0001\u0003vS\u0012\u0004\u0003fA\u001b.g!)\u0011\b\u0001C\u0001u\u00051A(\u001b8jiz\"\"a\u000f\u001f\u0011\u0005M\u0001\u0001\"\u0002\u00119\u0001\u0004\u0011\u0003f\u0001\u001f.g!\u001a\u0001(L\u001a\t\u000b\u0001\u0003A\u0011I!\u0002\t\r|\u0007/\u001f\u000b\u0003w\tCQaQ A\u0002\u0011\u000bQ!\u001a=ue\u0006\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012\u0003\u0002\u000bA\f'/Y7\n\u0005%3%\u0001\u0003)be\u0006lW*\u00199)\u0007}j3\u0007C\u0003:\u0001\u0011\u0005A\nF\u0001<Q\rYUf\r\u0005\u0006\u001f\u0002!\t\u0001U\u0001\u000fg\u0016$h)Z1ukJ,7oQ8m)\t\t&+D\u0001\u0001\u0011\u0015\u0019f\n1\u0001#\u0003\u00151\u0018\r\\;fQ\rqUf\r\u0005\u0006-\u0002!\taV\u0001\u0011g\u0016$\bK]3eS\u000e$\u0018n\u001c8D_2$\"!\u0015-\t\u000bM+\u0006\u0019\u0001\u0012)\u0007Uk3\u0007C\u0003\\\u0001\u0011\u0005A,\u0001\u0003tKR\\ECA)^\u0011\u0015\u0019&\f1\u0001_!\t!s,\u0003\u0002aK\t\u0019\u0011J\u001c;)\u0007ik3\u0007C\u0003d\u0001\u0011\u0005A-A\u0006tKRLe.\u001b;N_\u0012,GCA)f\u0011\u0015\u0019&\r1\u0001#Q\r\u0011Wf\r\u0005\u0006Q\u0002!\t![\u0001\rg\u0016$\u0018J\\5u'R,\u0007o\u001d\u000b\u0003#*DQaU4A\u0002yC3aZ\u00174\u0011\u0015i\u0007\u0001\"\u0001o\u0003)\u0019X\r^'bq&#XM\u001d\u000b\u0003#>DQa\u00157A\u0002yC3\u0001\\\u00174\u0011\u0015\u0011\b\u0001\"\u0001t\u0003\u0019\u0019X\r\u001e+pYR\u0011\u0011\u000b\u001e\u0005\u0006'F\u0004\r!\u001e\t\u0003IYL!a^\u0013\u0003\r\u0011{WO\u00197fQ\r\tXf\r\u0005\u0006u\u0002!\ta_\u0001\bg\u0016$8+Z3e)\t\tF\u0010C\u0003Ts\u0002\u0007Q\u0010\u0005\u0002%}&\u0011q0\n\u0002\u0005\u0019>tw\rK\u0002z[MBq!!\u0002\u0001\t\u0003\n9!A\u0002gSR$2AEA\u0005\u0011!\tY!a\u0001A\u0002\u00055\u0011a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003\u001f\ty\u0002\u0005\u0004\u0002\u0012\u0005]\u00111D\u0007\u0003\u0003'Q1!!\u0006\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u00033\t\u0019BA\u0004ECR\f7/\u001a;\u0011\t\u0005u\u0011q\u0004\u0007\u0001\t1\t\t#!\u0003\u0002\u0002\u0003\u0005)\u0011AA\u0012\u0005\ryFeM\t\u0005\u0003K\tY\u0003E\u0002%\u0003OI1!!\u000b&\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001JA\u0017\u0013\r\ty#\n\u0002\u0004\u0003:L\b&BA\u0002[\u0005M\u0012EAA\u001b\u0003\u0015\u0011d\u0006\r\u00181\u0011\u001d\tI\u0004\u0001C!\u0003w\tq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0005\u0003{\tI\u0005\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\u0011\t\u0019%a\u0005\u0002\u000bQL\b/Z:\n\t\u0005\u001d\u0013\u0011\t\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002CA&\u0003o\u0001\r!!\u0010\u0002\rM\u001c\u0007.Z7bQ\u0011\t9$L\u001a)\u0007\u0001i3gB\u0004\u0002T\tA\t!!\u0016\u0002\r-kU-\u00198t!\r\u0019\u0012q\u000b\u0004\u0007\u0003\tA\t!!\u0017\u0014\u0011\u0005]\u00131LA1\u0003O\u00022\u0001JA/\u0013\r\ty&\n\u0002\u0007\u0003:L(+\u001a4\u0011\ti\t\u0019gO\u0005\u0004\u0003KZ\"!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7OU3bI\u0006\u0014G.\u001a\t\u0004I\u0005%\u0014bAA6K\ta1+\u001a:jC2L'0\u00192mK\"9\u0011(a\u0016\u0005\u0002\u0005=DCAA+\u0011!\t\u0019(a\u0016\u0005B\u0005U\u0014\u0001\u00027pC\u0012$2aOA<\u0011\u001d\tI(!\u001dA\u0002\t\nA\u0001]1uQ\"*\u0011\u0011O\u0017\u0002~\u0005\u0012\u0011qP\u0001\u0006c92d\u0006\r\u0005\u000b\u0003\u0007\u000b9&!A\u0005\n\u0005\u0015\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\"\u0011\t\u0005%\u00151S\u0007\u0003\u0003\u0017SA!!$\u0002\u0010\u0006!A.\u00198h\u0015\t\t\t*\u0001\u0003kCZ\f\u0017\u0002BAK\u0003\u0017\u0013aa\u00142kK\u000e$\b&BA,[\u0005u\u0004&BA)[\u0005u\u0004")
public class KMeans
extends Estimator<KMeansModel>
implements KMeansParams,
DefaultParamsWritable {
    private final String uid;
    private final IntParam k;
    private final Param<String> initMode;
    private final IntParam initSteps;
    private final DoubleParam tol;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static MLReader<KMeans> read() {
        return KMeans$.MODULE$.read();
    }

    public static KMeans load(String string) {
        return KMeans$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final Param<String> initMode() {
        return this.initMode;
    }

    @Override
    public final IntParam initSteps() {
        return this.initSteps;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initMode_$eq(Param x$1) {
        this.initMode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initSteps_$eq(IntParam x$1) {
        this.initSteps = x$1;
    }

    @Override
    public int getK() {
        return KMeansParams$class.getK(this);
    }

    @Override
    public String getInitMode() {
        return KMeansParams$class.getInitMode(this);
    }

    @Override
    public int getInitSteps() {
        return KMeansParams$class.getInitSteps(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return KMeansParams$class.validateAndTransformSchema(this, schema);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public KMeans copy(ParamMap extra) {
        return (KMeans)this.defaultCopy(extra);
    }

    public KMeans setFeaturesCol(String value) {
        return (KMeans)this.set(this.featuresCol(), value);
    }

    public KMeans setPredictionCol(String value) {
        return (KMeans)this.set(this.predictionCol(), value);
    }

    public KMeans setK(int value) {
        return (KMeans)this.set(this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setInitMode(String value) {
        return (KMeans)this.set(this.initMode(), value);
    }

    public KMeans setInitSteps(int value) {
        return (KMeans)this.set(this.initSteps(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setMaxIter(int value) {
        return (KMeans)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setTol(double value) {
        return (KMeans)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public KMeans setSeed(long value) {
        return (KMeans)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public KMeansModel fit(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        StorageLevel storageLevel = dataset.storageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(Row x0$3) {
                Object point;
                Row row = x0$3;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (point = ((SeqLike)some.get()).apply(0)) instanceof org.apache.spark.ml.linalg.Vector) {
                    org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)point;
                    Vector vector2 = Vectors$.MODULE$.fromML(vector);
                    return vector2;
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
        Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        Instrumentation<KMeans> instr = Instrumentation$.MODULE$.create(this, instances);
        instr.logParams((Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.featuresCol(), this.predictionCol(), this.k(), this.initMode(), this.initSteps(), this.maxIter(), this.seed(), this.tol()}));
        org.apache.spark.mllib.clustering.KMeans algo = new org.apache.spark.mllib.clustering.KMeans().setK(BoxesRunTime.unboxToInt((Object)this.$(this.k()))).setInitializationMode(this.$(this.initMode())).setInitializationSteps(BoxesRunTime.unboxToInt((Object)this.$(this.initSteps()))).setMaxIterations(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter()))).setSeed(BoxesRunTime.unboxToLong((Object)this.$(this.seed()))).setEpsilon(BoxesRunTime.unboxToDouble((Object)this.$(this.tol())));
        org.apache.spark.mllib.clustering.KMeansModel parentModel = algo.run((RDD<Vector>)instances, (Option<Instrumentation<KMeans>>)Option$.MODULE$.apply(instr));
        KMeansModel model = this.copyValues(new KMeansModel(this.uid(), parentModel).setParent(this), this.copyValues$default$2());
        KMeansSummary summary2 = new KMeansSummary(model.transform(dataset), this.$(this.predictionCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())));
        model.setSummary((Option<KMeansSummary>)new Some((Object)summary2));
        instr.logSuccess(model);
        Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
        return model;
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public KMeans(String uid) {
        this.uid = uid;
        HasMaxIter$class.$init$(this);
        HasFeaturesCol$class.$init$(this);
        HasSeed$class.$init$(this);
        HasPredictionCol$class.$init$(this);
        HasTol$class.$init$(this);
        KMeansParams$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.k().$minus$greater(BoxesRunTime.boxToInteger((int)2)), this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)20)), this.initMode().$minus$greater(org.apache.spark.mllib.clustering.KMeans$.MODULE$.K_MEANS_PARALLEL()), this.initSteps().$minus$greater(BoxesRunTime.boxToInteger((int)2)), this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-4))}));
    }

    public KMeans() {
        this(Identifiable$.MODULE$.randomUID("kmeans"));
    }
}

