/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator$class;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001q4Q!\u0001\u0002\u0001\r9\u0011a\u0003T3bgR\u001c\u0016/^1sKN\fum\u001a:fO\u0006$xN\u001d\u0006\u0003\u0007\u0011\t!\"Y4he\u0016<\u0017\r^8s\u0015\t)a!A\u0003paRLWN\u0003\u0002\b\u0011\u0005\u0011Q\u000e\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0019\u0001aD\u000b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\u00111r#G\u0010\u000e\u0003\tI!\u0001\u0007\u0002\u00039\u0011KgMZ3sK:$\u0018.\u00192mK2{7o]!hOJ,w-\u0019;peB\u0011!$H\u0007\u00027)\u0011ADB\u0001\bM\u0016\fG/\u001e:f\u0013\tq2D\u0001\u0005J]N$\u0018M\\2f!\t1\u0002\u0001\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003$\u0003!a\u0017MY3m'R$7\u0001\u0001\t\u0003!\u0011J!!J\t\u0003\r\u0011{WO\u00197f\u0011!9\u0003A!A!\u0002\u0013\u0019\u0013!\u00037bE\u0016dW*Z1o\u0011!I\u0003A!A!\u0002\u0013Q\u0013\u0001\u00044ji&sG/\u001a:dKB$\bC\u0001\t,\u0013\ta\u0013CA\u0004C_>dW-\u00198\t\u00119\u0002!\u0011!Q\u0001\n=\nQBY2GK\u0006$XO]3t'R$\u0007c\u0001\u00194k5\t\u0011G\u0003\u00023\u0011\u0005I!M]8bI\u000e\f7\u000f^\u0005\u0003iE\u0012\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0007A14%\u0003\u00028#\t)\u0011I\u001d:bs\"A\u0011\b\u0001B\u0001B\u0003%q&\u0001\bcG\u001a+\u0017\r^;sKNlU-\u00198\t\u0011m\u0002!\u0011!Q\u0001\nq\naBY2D_\u00164g-[2jK:$8\u000fE\u00021gu\u0002\"AP!\u000e\u0003}R!\u0001\u0011\u0004\u0002\r1Lg.\u00197h\u0013\t\u0011uH\u0001\u0004WK\u000e$xN\u001d\u0005\u0006\t\u0002!\t!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0019C\u0015JS&M)\tyr\tC\u0003<\u0007\u0002\u0007A\bC\u0003\"\u0007\u0002\u00071\u0005C\u0003(\u0007\u0002\u00071\u0005C\u0003*\u0007\u0002\u0007!\u0006C\u0003/\u0007\u0002\u0007q\u0006C\u0003:\u0007\u0002\u0007q\u0006C\u0004O\u0001\t\u0007I\u0011B(\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0002!B\u0011\u0001#U\u0005\u0003%F\u00111!\u00138u\u0011\u0019!\u0006\u0001)A\u0005!\u0006aa.^7GK\u0006$XO]3tA!9a\u000b\u0001b\u0001\n#z\u0015a\u00013j[\"1\u0001\f\u0001Q\u0001\nA\u000bA\u0001Z5nA!A!\f\u0001EC\u0002\u0013%1,A\u0006gK\u0006$XO]3t'R$W#A\u001b\t\u0011u\u0003\u0001\u0012!Q!\nU\nABZ3biV\u0014Xm]*uI\u0002B#\u0001X0\u0011\u0005A\u0001\u0017BA1\u0012\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u0005d\u0001!\u0015\r\u0011\"\u0003e\u0003Y)gMZ3di&4XmQ8fM\u0006sGm\u00144gg\u0016$X#A3\u0011\tA1WhI\u0005\u0003OF\u0011a\u0001V;qY\u0016\u0014\u0004\u0002C5\u0001\u0011\u0003\u0005\u000b\u0015B3\u0002/\u00154g-Z2uSZ,7i\\3g\u0003:$wJ\u001a4tKR\u0004\u0003F\u00015`\u0011!a\u0007\u0001#b\u0001\n\u0013i\u0017aG3gM\u0016\u001cG/\u001b<f\u0007>,gMZ5dS\u0016tGo\u001d,fGR|'/F\u0001>\u0011!y\u0007\u0001#A!B\u0013i\u0014\u0001H3gM\u0016\u001cG/\u001b<f\u0007>,gMZ5dS\u0016tGo\u001d,fGR|'\u000f\t\u0015\u0003]~C\u0001B\u001d\u0001\t\u0006\u0004%Ia]\u0001\u0007_\u001a47/\u001a;\u0016\u0003\rB\u0001\"\u001e\u0001\t\u0002\u0003\u0006KaI\u0001\b_\u001a47/\u001a;!Q\t!x\fC\u0003y\u0001\u0011\u0005\u00110A\u0002bI\u0012$\"a\b>\t\u000bm<\b\u0019A\r\u0002\u0011%t7\u000f^1oG\u0016\u0004")
public class LeastSquaresAggregator
implements DifferentiableLossAggregator<Instance, LeastSquaresAggregator> {
    private final double labelStd;
    private final double labelMean;
    private final boolean fitIntercept;
    private final Broadcast<double[]> bcFeaturesStd;
    private final Broadcast<double[]> bcFeaturesMean;
    private final Broadcast<Vector> bcCoefficients;
    private final int org$apache$spark$ml$optim$aggregator$LeastSquaresAggregator$$numFeatures;
    private final int dim;
    private transient double[] featuresStd;
    private transient Tuple2<Vector, Object> effectiveCoefAndOffset;
    private transient Vector effectiveCoefficientsVector;
    private transient double offset;
    private double weightSum;
    private double lossSum;
    private final double[] gradientSumArray;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    private double[] featuresStd$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.featuresStd = (double[])this.bcFeaturesStd.value();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.featuresStd;
        }
    }

    private Tuple2 effectiveCoefAndOffset$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                double[] coefficientsArray = (double[])((Vector)this.bcCoefficients.value()).toArray().clone();
                double[] featuresMean = (double[])this.bcFeaturesMean.value();
                double sum = 0.0;
                int len = coefficientsArray.length;
                for (int i = 0; i < len; ++i) {
                    if (this.featuresStd()[i] != 0.0) {
                        int n = i;
                        coefficientsArray[n] = coefficientsArray[n] / this.featuresStd()[i];
                        sum += coefficientsArray[i] * featuresMean[i];
                        continue;
                    }
                    coefficientsArray[i] = 0.0;
                }
                double offset = this.fitIntercept ? this.labelMean / this.labelStd - sum : 0.0;
                this.effectiveCoefAndOffset = new Tuple2((Object)Vectors$.MODULE$.dense(coefficientsArray), (Object)BoxesRunTime.boxToDouble((double)offset));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.effectiveCoefAndOffset;
        }
    }

    private Vector effectiveCoefficientsVector$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.effectiveCoefficientsVector = (Vector)this.effectiveCoefAndOffset()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.effectiveCoefficientsVector;
        }
    }

    private double offset$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.offset = this.effectiveCoefAndOffset()._2$mcD$sp();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.offset;
        }
    }

    @Override
    public double weightSum() {
        return this.weightSum;
    }

    @Override
    @TraitSetter
    public void weightSum_$eq(double x$1) {
        this.weightSum = x$1;
    }

    @Override
    public double lossSum() {
        return this.lossSum;
    }

    @Override
    @TraitSetter
    public void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private double[] gradientSumArray$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if (!this.bitmap$0) {
                this.gradientSumArray = DifferentiableLossAggregator$class.gradientSumArray(this);
                this.bitmap$0 = true;
            }
            return this.gradientSumArray;
        }
    }

    @Override
    public double[] gradientSumArray() {
        return this.bitmap$0 ? this.gradientSumArray : this.gradientSumArray$lzycompute();
    }

    @Override
    public DifferentiableLossAggregator merge(DifferentiableLossAggregator other) {
        return DifferentiableLossAggregator$class.merge(this, other);
    }

    @Override
    public Vector gradient() {
        return DifferentiableLossAggregator$class.gradient(this);
    }

    @Override
    public double weight() {
        return DifferentiableLossAggregator$class.weight(this);
    }

    @Override
    public double loss() {
        return DifferentiableLossAggregator$class.loss(this);
    }

    public int org$apache$spark$ml$optim$aggregator$LeastSquaresAggregator$$numFeatures() {
        return this.org$apache$spark$ml$optim$aggregator$LeastSquaresAggregator$$numFeatures;
    }

    @Override
    public int dim() {
        return this.dim;
    }

    private double[] featuresStd() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.featuresStd$lzycompute() : this.featuresStd;
    }

    private Tuple2<Vector, Object> effectiveCoefAndOffset() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.effectiveCoefAndOffset$lzycompute() : this.effectiveCoefAndOffset;
    }

    private Vector effectiveCoefficientsVector() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.effectiveCoefficientsVector$lzycompute() : this.effectiveCoefficientsVector;
    }

    private double offset() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.offset$lzycompute() : this.offset;
    }

    @Override
    public LeastSquaresAggregator add(Instance instance) {
        Instance instance2 = instance;
        if (instance2 != null) {
            double label = instance2.label();
            double weight = instance2.weight();
            Vector features = instance2.features();
            Predef$.MODULE$.require(this.org$apache$spark$ml$optim$aggregator$LeastSquaresAggregator$$numFeatures() == features.size(), (Function0)new Serializable(this, features){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LeastSquaresAggregator $outer;
                private final Vector features$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimensions mismatch when adding new sample."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Expecting ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$optim$aggregator$LeastSquaresAggregator$$numFeatures()), BoxesRunTime.boxToInteger((int)this.features$1.size())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.features$1 = features$1;
                }
            });
            Predef$.MODULE$.require(weight >= 0.0, (Function0)new Serializable(this, weight){
                public static final long serialVersionUID = 0L;
                private final double weight$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"instance weight, ", " has to be >= 0.0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.weight$1)}));
                }
                {
                    this.weight$1 = weight$1;
                }
            });
            if (weight == 0.0) {
                return this;
            }
            double diff = BLAS$.MODULE$.dot(features, this.effectiveCoefficientsVector()) - label / this.labelStd + this.offset();
            if (diff != 0.0) {
                double[] localGradientSumArray = this.gradientSumArray();
                double[] localFeaturesStd = this.featuresStd();
                features.foreachActive((Function2)new Serializable(this, weight, diff, localGradientSumArray, localFeaturesStd){
                    public static final long serialVersionUID = 0L;
                    private final double weight$1;
                    private final double diff$1;
                    private final double[] localGradientSumArray$1;
                    private final double[] localFeaturesStd$1;

                    public final void apply(int index2, double value) {
                        this.apply$mcVID$sp(index2, value);
                    }

                    public void apply$mcVID$sp(int index2, double value) {
                        double fStd = this.localFeaturesStd$1[index2];
                        if (fStd != 0.0 && value != 0.0) {
                            this.localGradientSumArray$1[index2] = this.localGradientSumArray$1[index2] + this.weight$1 * this.diff$1 * value / fStd;
                        }
                    }
                    {
                        this.weight$1 = weight$1;
                        this.diff$1 = diff$1;
                        this.localGradientSumArray$1 = localGradientSumArray$1;
                        this.localFeaturesStd$1 = localFeaturesStd$1;
                    }
                });
                this.lossSum_$eq(this.lossSum() + weight * diff * diff / 2.0);
            }
            this.weightSum_$eq(this.weightSum() + weight);
            LeastSquaresAggregator leastSquaresAggregator = this;
            return leastSquaresAggregator;
        }
        throw new MatchError((Object)instance2);
    }

    public LeastSquaresAggregator(double labelStd, double labelMean, boolean fitIntercept, Broadcast<double[]> bcFeaturesStd, Broadcast<double[]> bcFeaturesMean, Broadcast<Vector> bcCoefficients) {
        this.labelStd = labelStd;
        this.labelMean = labelMean;
        this.fitIntercept = fitIntercept;
        this.bcFeaturesStd = bcFeaturesStd;
        this.bcFeaturesMean = bcFeaturesMean;
        this.bcCoefficients = bcCoefficients;
        DifferentiableLossAggregator$class.$init$(this);
        Predef$.MODULE$.require(labelStd > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeastSquaresAggregator $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " requires the label standard "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.getClass().getName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deviation to be positive."})).s((Seq)Nil$.MODULE$)).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$ml$optim$aggregator$LeastSquaresAggregator$$numFeatures = ((double[])bcFeaturesStd.value()).length;
        this.dim = this.org$apache$spark$ml$optim$aggregator$LeastSquaresAggregator$$numFeatures();
    }
}

