/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.python;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.PickleUtils;
import net.razorvine.pickle.Pickler;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.python.MLSerDe$;
import org.apache.spark.mllib.api.python.SerDeBase;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rtAB\u0001\u0003\u0011\u00031A\"A\u0004N\u0019N+'\u000fR3\u000b\u0005\r!\u0011A\u00029zi\"|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sOB\u0011QBD\u0007\u0002\u0005\u00191qB\u0001E\u0001\rA\u0011q!\u0014'TKJ$UmE\u0002\u000f#i\u0001\"A\u0005\r\u000e\u0003MQ!a\u0001\u000b\u000b\u0005U1\u0012aA1qS*\u0011qCB\u0001\u0006[2d\u0017NY\u0005\u00033M\u0011\u0011bU3s\t\u0016\u0014\u0015m]3\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000b\u0005rA\u0011A\u0012\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001\u0004\u0005\bK9\u0011\r\u0011\"\u0011'\u0003=\u0001\u0016l\u0015)B%.{\u0006+Q\"L\u0003\u001e+U#A\u0014\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013\u0001\u00027b]\u001eT\u0011\u0001L\u0001\u0005U\u00064\u0018-\u0003\u0002/S\t11\u000b\u001e:j]\u001eDa\u0001\r\b!\u0002\u00139\u0013\u0001\u0005)Z'B\u000b%kS0Q\u0003\u000e[\u0015iR#!\r\u0015\u0011d\u0002\u0001\u00024\u0005I!UM\\:f-\u0016\u001cGo\u001c:QS\u000e\\G.\u001a:\u0014\u0005E\"\u0004cA\u001b7q5\ta\"\u0003\u000281\tY!)Y:f!&\u001c7\u000e\\3s!\tID(D\u0001;\u0015\tYD!\u0001\u0004mS:\fGnZ\u0005\u0003{i\u00121\u0002R3og\u00164Vm\u0019;pe\")\u0011%\rC\u0001\u007fQ\t\u0001\t\u0005\u00026c!)!)\rC\u0001\u0007\u0006I1/\u0019<f'R\fG/\u001a\u000b\u0005\t\u001ecE\u000b\u0005\u0002\u001c\u000b&\u0011a\t\b\u0002\u0005+:LG\u000fC\u0003I\u0003\u0002\u0007\u0011*A\u0002pE*\u0004\"\u0001\u000b&\n\u0005-K#AB(cU\u0016\u001cG\u000fC\u0003N\u0003\u0002\u0007a*A\u0002pkR\u0004\"a\u0014*\u000e\u0003AS!!U\u0016\u0002\u0005%|\u0017BA*Q\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u0015)\u0016\t1\u0001W\u0003\u001d\u0001\u0018nY6mKJ\u0004\"a\u00160\u000e\u0003aS!!\u0017.\u0002\rAL7m\u001b7f\u0015\tYF,A\u0005sCj|'O^5oK*\tQ,A\u0002oKRL!a\u0018-\u0003\u000fAK7m\u001b7fe\")\u0011-\rC\u0001E\u0006I1m\u001c8tiJ,8\r\u001e\u000b\u0003\u0013\u000eDQ\u0001\u001a1A\u0002\u0015\fA!\u0019:hgB\u00191DZ%\n\u0005\u001dd\"!B!se\u0006Lh!B5\u000f\u0001\tQ'A\u0005#f]N,W*\u0019;sSb\u0004\u0016nY6mKJ\u001c\"\u0001[6\u0011\u0007U2D\u000e\u0005\u0002:[&\u0011aN\u000f\u0002\f\t\u0016t7/Z'biJL\u0007\u0010C\u0003\"Q\u0012\u0005\u0001\u000fF\u0001r!\t)\u0004\u000eC\u0003CQ\u0012\u00051\u000f\u0006\u0003EiV4\b\"\u0002%s\u0001\u0004I\u0005\"B's\u0001\u0004q\u0005\"B+s\u0001\u00041\u0006\"B1i\t\u0003AHCA%z\u0011\u0015!w\u000f1\u0001f\r\u0015Yh\u0002\u0001\u0002}\u0005M\u0019\u0006/\u0019:tK6\u000bGO]5y!&\u001c7\u000e\\3s'\tQX\u0010E\u00026my\u0004\"!O@\n\u0007\u0005\u0005!H\u0001\u0007Ta\u0006\u00148/Z'biJL\u0007\u0010\u0003\u0004\"u\u0012\u0005\u0011Q\u0001\u000b\u0003\u0003\u000f\u0001\"!\u000e>\t\r\tSH\u0011AA\u0006)\u001d!\u0015QBA\b\u0003#Aa\u0001SA\u0005\u0001\u0004I\u0005BB'\u0002\n\u0001\u0007a\n\u0003\u0004V\u0003\u0013\u0001\rA\u0016\u0005\u0007Cj$\t!!\u0006\u0015\u0007%\u000b9\u0002\u0003\u0004e\u0003'\u0001\r!\u001a\u0004\b\u00037q\u0001AAA\u000f\u0005M\u0019\u0006/\u0019:tKZ+7\r^8s!&\u001c7\u000e\\3s'\u0011\tI\"a\b\u0011\tU2\u0014\u0011\u0005\t\u0004s\u0005\r\u0012bAA\u0013u\ta1\u000b]1sg\u00164Vm\u0019;pe\"9\u0011%!\u0007\u0005\u0002\u0005%BCAA\u0016!\r)\u0014\u0011\u0004\u0005\b\u0005\u0006eA\u0011AA\u0018)\u001d!\u0015\u0011GA\u001a\u0003kAa\u0001SA\u0017\u0001\u0004I\u0005BB'\u0002.\u0001\u0007a\n\u0003\u0004V\u0003[\u0001\rA\u0016\u0005\bC\u0006eA\u0011AA\u001d)\rI\u00151\b\u0005\u0007I\u0006]\u0002\u0019A3\t\u0013\u0005}b\u00021A\u0005\u0002\u0005\u0005\u0013aC5oSRL\u0017\r\\5{K\u0012,\"!a\u0011\u0011\u0007m\t)%C\u0002\u0002Hq\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002L9\u0001\r\u0011\"\u0001\u0002N\u0005y\u0011N\\5uS\u0006d\u0017N_3e?\u0012*\u0017\u000fF\u0002E\u0003\u001fB!\"!\u0015\u0002J\u0005\u0005\t\u0019AA\"\u0003\rAH%\r\u0005\t\u0003+r\u0001\u0015)\u0003\u0002D\u0005a\u0011N\\5uS\u0006d\u0017N_3eA!9\u0011\u0011\f\b\u0005B\u0005m\u0013AC5oSRL\u0017\r\\5{KR\tA\tC\u0005\u0002`9\t\t\u0011\"\u0003\u0002b\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005I\u0005")
public final class MLSerDe {
    public static void initialize() {
        MLSerDe$.MODULE$.initialize();
    }

    public static void initialized_$eq(boolean bl) {
        MLSerDe$.MODULE$.initialized_$eq(bl);
    }

    public static boolean initialized() {
        return MLSerDe$.MODULE$.initialized();
    }

    public static String PYSPARK_PACKAGE() {
        return MLSerDe$.MODULE$.PYSPARK_PACKAGE();
    }

    public static JavaRDD<Object> pythonToJava(JavaRDD<byte[]> javaRDD, boolean bl) {
        return MLSerDe$.MODULE$.pythonToJava(javaRDD, bl);
    }

    public static JavaRDD<byte[]> javaToPython(JavaRDD<Object> javaRDD) {
        return MLSerDe$.MODULE$.javaToPython(javaRDD);
    }

    public static RDD<Object[]> fromTuple2RDD(RDD<Tuple2<Object, Object>> rDD) {
        return MLSerDe$.MODULE$.fromTuple2RDD(rDD);
    }

    public static RDD<Tuple2<Object, Object>> asTupleRDD(RDD<Object[]> rDD) {
        return MLSerDe$.MODULE$.asTupleRDD(rDD);
    }

    public static Object loads(byte[] byArray) {
        return MLSerDe$.MODULE$.loads(byArray);
    }

    public static byte[] dumps(Object object) {
        return MLSerDe$.MODULE$.dumps(object);
    }

    public static class DenseVectorPickler
    extends SerDeBase.BasePickler<DenseVector> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            DenseVector vector = (DenseVector)obj;
            byte[] bytes = new byte[8 * vector.size()];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(ByteOrder.nativeOrder());
            DoubleBuffer db = bb.asDoubleBuffer();
            db.put(vector.values());
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)bytes.length));
            out.write(bytes);
            out.write(133);
        }

        public Object construct(Object[] args) {
            if (args.length != 1) {
                throw new PickleException("length of args should be 1");
            }
            byte[] bytes = this.getBytes(args[0]);
            ByteBuffer bb = ByteBuffer.wrap(bytes, 0, bytes.length);
            bb.order(ByteOrder.nativeOrder());
            DoubleBuffer db = bb.asDoubleBuffer();
            double[] ans = new double[bytes.length / 8];
            db.get(ans);
            return Vectors$.MODULE$.dense(ans);
        }

        public DenseVectorPickler() {
            super(ClassTag$.MODULE$.apply(DenseVector.class));
        }
    }

    public static class DenseMatrixPickler
    extends SerDeBase.BasePickler<DenseMatrix> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            DenseMatrix m = (DenseMatrix)obj;
            byte[] bytes = new byte[8 * m.values().length];
            ByteOrder order = ByteOrder.nativeOrder();
            int isTransposed = m.isTransposed() ? 1 : 0;
            ByteBuffer.wrap(bytes).order(order).asDoubleBuffer().put(m.values());
            out.write(40);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)m.numRows()));
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)m.numCols()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)bytes.length));
            out.write(bytes);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)isTransposed));
            out.write(116);
        }

        public Object construct(Object[] args) {
            if (args.length != 4) {
                throw new PickleException("length of args should be 4");
            }
            byte[] bytes = this.getBytes(args[2]);
            int n = bytes.length / 8;
            double[] values = new double[n];
            ByteOrder order = ByteOrder.nativeOrder();
            ByteBuffer.wrap(bytes).order(order).asDoubleBuffer().get(values);
            boolean isTransposed = BoxesRunTime.unboxToInt((Object)args[3]) == 1;
            return new DenseMatrix(BoxesRunTime.unboxToInt((Object)args[0]), BoxesRunTime.unboxToInt((Object)args[1]), values, isTransposed);
        }

        public DenseMatrixPickler() {
            super(ClassTag$.MODULE$.apply(DenseMatrix.class));
        }
    }

    public static class SparseMatrixPickler
    extends SerDeBase.BasePickler<SparseMatrix> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            SparseMatrix s = (SparseMatrix)obj;
            ByteOrder order = ByteOrder.nativeOrder();
            byte[] colPtrsBytes = new byte[4 * s.colPtrs().length];
            byte[] indicesBytes = new byte[4 * s.rowIndices().length];
            byte[] valuesBytes = new byte[8 * s.values().length];
            int isTransposed = s.isTransposed() ? 1 : 0;
            ByteBuffer.wrap(colPtrsBytes).order(order).asIntBuffer().put(s.colPtrs());
            ByteBuffer.wrap(indicesBytes).order(order).asIntBuffer().put(s.rowIndices());
            ByteBuffer.wrap(valuesBytes).order(order).asDoubleBuffer().put(s.values());
            out.write(40);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)s.numRows()));
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)s.numCols()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)colPtrsBytes.length));
            out.write(colPtrsBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)indicesBytes.length));
            out.write(indicesBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)valuesBytes.length));
            out.write(valuesBytes);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)isTransposed));
            out.write(116);
        }

        public Object construct(Object[] args) {
            if (args.length != 6) {
                throw new PickleException("length of args should be 6");
            }
            ByteOrder order = ByteOrder.nativeOrder();
            byte[] colPtrsBytes = this.getBytes(args[2]);
            byte[] indicesBytes = this.getBytes(args[3]);
            byte[] valuesBytes = this.getBytes(args[4]);
            int[] colPtrs = new int[colPtrsBytes.length / 4];
            int[] rowIndices = new int[indicesBytes.length / 4];
            double[] values = new double[valuesBytes.length / 8];
            ByteBuffer.wrap(colPtrsBytes).order(order).asIntBuffer().get(colPtrs);
            ByteBuffer.wrap(indicesBytes).order(order).asIntBuffer().get(rowIndices);
            ByteBuffer.wrap(valuesBytes).order(order).asDoubleBuffer().get(values);
            boolean isTransposed = BoxesRunTime.unboxToInt((Object)args[5]) == 1;
            return new SparseMatrix(BoxesRunTime.unboxToInt((Object)args[0]), BoxesRunTime.unboxToInt((Object)args[1]), colPtrs, rowIndices, values, isTransposed);
        }

        public SparseMatrixPickler() {
            super(ClassTag$.MODULE$.apply(SparseMatrix.class));
        }
    }

    public static class SparseVectorPickler
    extends SerDeBase.BasePickler<SparseVector> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            SparseVector v = (SparseVector)obj;
            int n = v.indices().length;
            byte[] indiceBytes = new byte[4 * n];
            ByteOrder order = ByteOrder.nativeOrder();
            ByteBuffer.wrap(indiceBytes).order(order).asIntBuffer().put(v.indices());
            byte[] valueBytes = new byte[8 * n];
            ByteBuffer.wrap(valueBytes).order(order).asDoubleBuffer().put(v.values());
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)v.size()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)indiceBytes.length));
            out.write(indiceBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)valueBytes.length));
            out.write(valueBytes);
            out.write(135);
        }

        public Object construct(Object[] args) {
            Object object;
            if (args.length != 3) {
                throw new PickleException("length of args should be 3");
            }
            int size = BoxesRunTime.unboxToInt((Object)args[0]);
            byte[] indiceBytes = this.getBytes(args[1]);
            byte[] valueBytes = this.getBytes(args[2]);
            int n = indiceBytes.length / 4;
            int[] indices = new int[n];
            double[] values = new double[n];
            if (n > 0) {
                ByteOrder order = ByteOrder.nativeOrder();
                ByteBuffer.wrap(indiceBytes).order(order).asIntBuffer().get(indices);
                object = ByteBuffer.wrap(valueBytes).order(order).asDoubleBuffer().get(values);
            } else {
                object = BoxedUnit.UNIT;
            }
            return new SparseVector(size, indices, values);
        }

        public SparseVectorPickler() {
            super(ClassTag$.MODULE$.apply(SparseVector.class));
        }
    }
}

