/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.Optional;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.execution.streaming.RateSourceProvider$;
import org.apache.spark.sql.execution.streaming.RateStreamSource;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.continuous.RateStreamContinuousReader;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.StreamSourceProvider;
import org.apache.spark.sql.sources.v2.ContinuousReadSupport;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousReader;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0001\u0003\u0001=\u0011!CU1uKN{WO]2f!J|g/\u001b3fe*\u00111\u0001B\u0001\ngR\u0014X-Y7j]\u001eT!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0002\u0001\u0011-qyR\u0005\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0019\tqa]8ve\u000e,7/\u0003\u0002\u001c1\t!2\u000b\u001e:fC6\u001cv.\u001e:dKB\u0013xN^5eKJ\u0004\"aF\u000f\n\u0005yA\"A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\r\u0002\u0005Y\u0014\u0014B\u0001\u0013\"\u00051!\u0015\r^1T_V\u00148-\u001a,3!\t\u0001c%\u0003\u0002(C\t)2i\u001c8uS:,x.^:SK\u0006$7+\u001e9q_J$\b\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\bF\u0001,!\ta\u0003!D\u0001\u0003\u0011\u0015q\u0003\u0001\"\u00110\u00031\u0019x.\u001e:dKN\u001b\u0007.Z7b)\u0015\u0001\u0004IR&N!\u0011\t\u0012g\r\u001e\n\u0005I\u0012\"A\u0002+va2,'\u0007\u0005\u00025o9\u0011\u0011#N\u0005\u0003mI\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011aG\u0005\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{\u0019\tQ\u0001^=qKNL!a\u0010\u001f\u0003\u0015M#(/^2u)f\u0004X\rC\u0003B[\u0001\u0007!)\u0001\u0006tc2\u001cuN\u001c;fqR\u0004\"a\u0011#\u000e\u0003\u0019I!!\u0012\u0004\u0003\u0015M\u000bFjQ8oi\u0016DH\u000fC\u0003H[\u0001\u0007\u0001*\u0001\u0004tG\",W.\u0019\t\u0004#%S\u0014B\u0001&\u0013\u0005\u0019y\u0005\u000f^5p]\")A*\fa\u0001g\u0005a\u0001O]8wS\u0012,'OT1nK\")a*\fa\u0001\u001f\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0011\tQ\u00026gM\u0005\u0003#f\u00121!T1q\u0011\u0015\u0019\u0006\u0001\"\u0011U\u00031\u0019'/Z1uKN{WO]2f)\u0019)\u0006,W.];B\u0011AFV\u0005\u0003/\n\u0011aaU8ve\u000e,\u0007\"B!S\u0001\u0004\u0011\u0005\"\u0002.S\u0001\u0004\u0019\u0014\u0001D7fi\u0006$\u0017\r^1QCRD\u0007\"B$S\u0001\u0004A\u0005\"\u0002'S\u0001\u0004\u0019\u0004\"\u0002(S\u0001\u0004y\u0005\"B0\u0001\t\u0003\u0002\u0017AF2sK\u0006$XmQ8oi&tWo\\;t%\u0016\fG-\u001a:\u0015\t\u0005D\u0017o\u001d\t\u0003E\u001al\u0011a\u0019\u0006\u0003\u0007\u0011T!!Z\u0011\u0002\rI,\u0017\rZ3s\u0013\t97M\u0001\tD_:$\u0018N\\;pkN\u0014V-\u00193fe\")qI\u0018a\u0001SB\u0019!n\u001c\u001e\u000e\u0003-T!\u0001\\7\u0002\tU$\u0018\u000e\u001c\u0006\u0002]\u0006!!.\u0019<b\u0013\t\u00018N\u0001\u0005PaRLwN\\1m\u0011\u0015\u0011h\f1\u00014\u0003I\u0019\u0007.Z2la>Lg\u000e\u001e'pG\u0006$\u0018n\u001c8\t\u000bQt\u0006\u0019A;\u0002\u000f=\u0004H/[8ogB\u0011\u0001E^\u0005\u0003o\u0006\u0012\u0011\u0003R1uCN{WO]2f\u001fB$\u0018n\u001c8t\u0011\u0015I\b\u0001\"\u0011{\u0003%\u0019\bn\u001c:u\u001d\u0006lW\rF\u00014\u000f\u0015a(\u0001#\u0001~\u0003I\u0011\u0016\r^3T_V\u00148-\u001a)s_ZLG-\u001a:\u0011\u00051rh!B\u0001\u0003\u0011\u0003y8C\u0001@\u0011\u0011\u0019Ic\u0010\"\u0001\u0002\u0004Q\tQ\u0010C\u0005\u0002\by\u0014\r\u0011\"\u0001\u0002\n\u000511k\u0011%F\u001b\u0006+\u0012A\u000f\u0005\b\u0003\u001bq\b\u0015!\u0003;\u0003\u001d\u00196\tS#N\u0003\u0002B\u0011\"!\u0005\u007f\u0005\u0004%\t!a\u0005\u0002\u000fY+%kU%P\u001dV\u0011\u0011Q\u0003\t\u0004#\u0005]\u0011bAA\r%\t\u0019\u0011J\u001c;\t\u0011\u0005ua\u0010)A\u0005\u0003+\t\u0001BV#S'&{e\n\t")
public class RateSourceProvider
implements StreamSourceProvider,
DataSourceRegister,
ContinuousReadSupport {
    public static int VERSION() {
        return RateSourceProvider$.MODULE$.VERSION();
    }

    public static StructType SCHEMA() {
        return RateSourceProvider$.MODULE$.SCHEMA();
    }

    @Override
    public Tuple2<String, StructType> sourceSchema(SQLContext sqlContext, Option<StructType> schema2, String providerName, Map<String, String> parameters) {
        if (schema2.nonEmpty()) {
            throw new AnalysisException("The rate source does not support a user-specified schema.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return new Tuple2((Object)this.shortName(), (Object)RateSourceProvider$.MODULE$.SCHEMA());
    }

    @Override
    public Source createSource(SQLContext sqlContext, String metadataPath, Option<StructType> schema2, String providerName, Map<String, String> parameters) {
        CaseInsensitiveMap params = CaseInsensitiveMap$.MODULE$.apply(parameters);
        long rowsPerSecond = BoxesRunTime.unboxToLong((Object)params.get("rowsPerSecond").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 1L;
            }
        }));
        if (rowsPerSecond <= 0L) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value '", "'. The option 'rowsPerSecond' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.apply((Object)"rowsPerSecond")}))).append((Object)"must be positive").toString());
        }
        long rampUpTimeSeconds = BoxesRunTime.unboxToLong((Object)params.get("rampUpTime").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$2) {
                return JavaUtils.timeStringAsSec((String)x$2);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        if (rampUpTimeSeconds < 0L) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value '", "'. The option 'rampUpTime' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.apply((Object)"rampUpTime")}))).append((Object)"must not be negative").toString());
        }
        int numPartitions = BoxesRunTime.unboxToInt((Object)params.get("numPartitions").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
            }
        }).getOrElse((Function0)new Serializable(this, sqlContext){
            public static final long serialVersionUID = 0L;
            private final SQLContext sqlContext$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.sqlContext$1.sparkContext().defaultParallelism();
            }
            {
                this.sqlContext$1 = sqlContext$1;
            }
        }));
        if (numPartitions <= 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value '", "'. The option 'numPartitions' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.apply((Object)"numPartitions")}))).append((Object)"must be positive").toString());
        }
        return new RateStreamSource(sqlContext, metadataPath, rowsPerSecond, rampUpTimeSeconds, numPartitions, BoxesRunTime.unboxToBoolean((Object)params.get("useManualClock").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        })));
    }

    @Override
    public ContinuousReader createContinuousReader(Optional<StructType> schema2, String checkpointLocation, DataSourceOptions options) {
        return new RateStreamContinuousReader(options);
    }

    @Override
    public String shortName() {
        return "rate";
    }
}

