/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.velocity.context;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextWrapper;
import org.apache.tiles.servlet.context.ExternalWriterHttpServletResponse;
import org.apache.tiles.servlet.context.ServletUtil;
import org.apache.velocity.context.Context;

public class VelocityTilesRequestContext
extends TilesRequestContextWrapper {
    private final Context ctx;
    private Object[] requestObjects;
    private Writer writer;

    public VelocityTilesRequestContext(TilesRequestContext enclosedRequest, Context ctx, Writer writer) {
        super(enclosedRequest);
        this.ctx = ctx;
        this.writer = writer;
    }

    public void dispatch(String path) throws IOException {
        this.include(path);
    }

    public void include(String path) throws IOException {
        Object[] requestObjects = super.getRequestObjects();
        HttpServletRequest request = (HttpServletRequest)requestObjects[0];
        HttpServletResponse response = (HttpServletResponse)requestObjects[1];
        ServletUtil.setForceInclude((HttpServletRequest)request, (boolean)true);
        RequestDispatcher rd = request.getRequestDispatcher(path);
        if (rd == null) {
            throw new IOException("No request dispatcher returned for path '" + path + "'");
        }
        PrintWriter printWriter = this.getPrintWriter();
        try {
            rd.include((ServletRequest)request, (ServletResponse)new ExternalWriterHttpServletResponse(response, printWriter));
        }
        catch (ServletException ex) {
            throw ServletUtil.wrapServletException((ServletException)ex, (String)("ServletException including path '" + path + "'."));
        }
    }

    public PrintWriter getPrintWriter() throws IOException {
        if (this.writer == null) {
            throw new IllegalStateException("A writer-less Tiles request has been created, cannot return a PrintWriter");
        }
        if (this.writer instanceof PrintWriter) {
            return (PrintWriter)this.writer;
        }
        return new PrintWriter(this.writer);
    }

    public Writer getWriter() throws IOException {
        if (this.writer == null) {
            throw new IllegalStateException("A writer-less Tiles request has been created, cannot return a PrintWriter");
        }
        return this.writer;
    }

    public Object[] getRequestObjects() {
        if (this.requestObjects == null) {
            Object[] parentRequestObjects = super.getRequestObjects();
            this.requestObjects = this.writer == null ? new Object[parentRequestObjects.length + 1] : new Object[parentRequestObjects.length + 2];
            this.requestObjects[0] = this.ctx;
            for (int i = 0; i < parentRequestObjects.length; ++i) {
                this.requestObjects[i + 1] = parentRequestObjects[i];
            }
            if (this.writer != null) {
                this.requestObjects[parentRequestObjects.length + 1] = this.writer;
            }
        }
        return this.requestObjects;
    }
}

