/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.KeyStore;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.res.StringManager;

class Jre8Compat
extends JreCompat {
    private static final Log log = LogFactory.getLog(Jre8Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre8Compat.class);
    private static final int RUNTIME_MAJOR_VERSION = 8;
    private static final Method setUseCipherSuitesOrderMethod;
    private static final Constructor<?> domainLoadStoreParameterConstructor;

    Jre8Compat() {
    }

    static boolean isSupported() {
        return setUseCipherSuitesOrderMethod != null;
    }

    @Override
    public void setUseServerCipherSuitesOrder(SSLEngine engine, boolean useCipherSuitesOrder) {
        SSLParameters sslParameters = engine.getSSLParameters();
        try {
            setUseCipherSuitesOrderMethod.invoke((Object)sslParameters, useCipherSuitesOrder);
            engine.setSSLParameters(sslParameters);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public KeyStore.LoadStoreParameter getDomainLoadStoreParameter(URI uri) {
        try {
            return (KeyStore.LoadStoreParameter)domainLoadStoreParameterConstructor.newInstance(uri, Collections.EMPTY_MAP);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int jarFileRuntimeMajorVersion() {
        return 8;
    }

    static {
        Method m1 = null;
        Constructor<?> c2 = null;
        try {
            Class<?> clazz1 = Class.forName("javax.net.ssl.SSLParameters");
            m1 = clazz1.getMethod("setUseCipherSuitesOrder", Boolean.TYPE);
            Class<?> clazz2 = Class.forName("java.security.DomainLoadStoreParameter");
            c2 = clazz2.getConstructor(URI.class, Map.class);
        }
        catch (SecurityException e) {
            log.error((Object)sm.getString("jre8Compat.unexpected"), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            if (m1 == null) {
                log.debug((Object)sm.getString("jre8Compat.javaPre8"), (Throwable)e);
            } else {
                log.error((Object)sm.getString("jre8Compat.unexpected"), (Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)sm.getString("jre8Compat.unexpected"), (Throwable)e);
        }
        setUseCipherSuitesOrderMethod = m1;
        domainLoadStoreParameterConstructor = c2;
    }
}

